/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.fuin.esc.api.Deserializer;
import org.fuin.esc.api.DeserializerRegistry;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.SerDeserializer;
import org.fuin.esc.api.SerDeserializerRegistry;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.SerializedDataTypeRegistry;
import org.fuin.esc.api.Serializer;
import org.fuin.esc.api.SerializerRegistry;
import org.fuin.esc.jackson.Base64Data;
import org.fuin.esc.jackson.EscEvent;
import org.fuin.esc.jackson.EscEvents;
import org.fuin.esc.jackson.EscMeta;
import org.fuin.esc.jackson.JacksonSerDeserializer;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Currently no methods worth to test")
public final class EscJacksonUtils {
    public static final EnhancedMimeType MIME_TYPE = EnhancedMimeType.create((String)"application", (String)"json", (Charset)StandardCharsets.UTF_8);

    private EscJacksonUtils() {
        throw new UnsupportedOperationException("Creating instances of a utility class is not allowed.");
    }

    public static <T extends SerializedDataTypeRegistry, B extends SerializedDataTypeRegistry.Builder<T, B>> B addEscTypes(B builder) {
        builder.add(EscEvents.SER_TYPE, EscEvents.class);
        builder.add(EscEvent.SER_TYPE, EscEvent.class);
        builder.add(EscMeta.SER_TYPE, EscMeta.class);
        builder.add(Base64Data.SER_TYPE, Base64Data.class);
        return builder;
    }

    public static <T extends SerDeserializerRegistry, B extends SerDeserializerRegistry.Builder<T, B>> B addEscSerDeserializer(B builder, JacksonSerDeserializer serDeserializer) {
        builder.add(EscEvents.SER_TYPE, (SerDeserializer)serDeserializer, serDeserializer.getMimeType());
        builder.add(EscEvent.SER_TYPE, (SerDeserializer)serDeserializer, serDeserializer.getMimeType());
        builder.add(EscMeta.SER_TYPE, (SerDeserializer)serDeserializer, serDeserializer.getMimeType());
        builder.add(Base64Data.SER_TYPE, (SerDeserializer)serDeserializer, serDeserializer.getMimeType());
        return builder;
    }

    public static void serialize(JsonGenerator generator, SerializerRegistry serializerRegistry, SerializedDataType serDataType, String key, Object data) {
        try {
            Serializer serializer = serializerRegistry.getSerializer(serDataType);
            if (serializer.getMimeType().matchEncoding(MIME_TYPE)) {
                generator.writeObjectField(key, data);
            } else {
                byte[] bytes = serializer.marshal(data, serDataType);
                String base64 = Base64.getEncoder().encodeToString(bytes);
                generator.writeStringField(key, base64);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to serialize '" + key + "': " + String.valueOf(data), ex);
        }
    }

    public static Object deserialize(JsonNode dataNode, SerializedDataType dataType, EnhancedMimeType dataContentType, DeserializerRegistry deserializerRegistry) {
        byte[] bytes;
        if (dataContentType.getEncoding() == null) {
            throw new IllegalStateException("Expected 'meta.data-content-type' to be set, but it's null");
        }
        if (dataNode.getNodeType() == JsonNodeType.STRING) {
            String base64 = dataNode.asText();
            bytes = Base64.getDecoder().decode(base64);
        } else if (dataNode.isObject()) {
            bytes = dataNode.toString().getBytes(dataContentType.getEncoding());
        } else {
            throw new IllegalStateException("Unexpected content type '" + String.valueOf(dataNode.getNodeType()) + "': " + String.valueOf(dataNode));
        }
        Deserializer deserializer = deserializerRegistry.getDeserializer(dataType, dataContentType);
        return deserializer.unmarshal((Object)bytes, dataType, dataContentType);
    }
}

