/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.HasSerializedDataTypeConstant;
import org.fuin.esc.api.IEscMeta;
import org.fuin.objects4j.common.Contract;

@HasSerializedDataTypeConstant
public final class EscMeta
implements IEscMeta {
    private String dataType;
    private String dataContentTypeStr;
    private String metaType;
    private String metaContentTypeStr;
    private Object meta;
    private transient EnhancedMimeType dataContentType;
    private transient EnhancedMimeType metaContentType;

    protected EscMeta() {
    }

    public EscMeta(@NotNull String dataType, @NotNull EnhancedMimeType dataContentType) {
        this(dataType, dataContentType, null, null, null);
    }

    public EscMeta(@NotNull String dataType, @NotNull EnhancedMimeType dataContentType, @Nullable String metaType, @Nullable EnhancedMimeType metaContentType, @Nullable Object meta) {
        Contract.requireArgNotNull((String)"dataType", (Object)dataType);
        Contract.requireArgNotNull((String)"dataContentType", (Object)dataContentType);
        if (meta != null) {
            Contract.requireArgNotNull((String)"metaType", (Object)metaType);
            Contract.requireArgNotNull((String)"metaContentType", (Object)metaContentType);
        }
        this.dataType = dataType;
        this.dataContentType = dataContentType;
        this.dataContentTypeStr = dataContentType.toString();
        this.metaType = metaType;
        this.metaContentType = metaContentType;
        if (metaContentType != null) {
            this.metaContentTypeStr = metaContentType.toString();
        }
        this.meta = meta;
    }

    @NotNull
    public String getDataType() {
        return this.dataType;
    }

    void setDataType(@NotNull String dataType) {
        Contract.requireArgNotNull((String)"dataType", (Object)dataType);
        this.dataType = dataType;
    }

    @NotNull
    public EnhancedMimeType getDataContentType() {
        if (this.dataContentType == null) {
            this.dataContentType = EnhancedMimeType.create((String)this.dataContentTypeStr);
        }
        return this.dataContentType;
    }

    void setDataContentType(EnhancedMimeType dataContentType) {
        Contract.requireArgNotNull((String)"dataContentType", (Object)dataContentType);
        this.dataContentType = dataContentType;
        this.dataContentTypeStr = dataContentType.toString();
    }

    @Nullable
    public String getMetaType() {
        return this.metaType;
    }

    public void setMetaType(@Nullable String metaType) {
        this.metaType = metaType;
    }

    @Nullable
    public EnhancedMimeType getMetaContentType() {
        if (this.metaContentType == null && this.metaContentTypeStr != null) {
            this.metaContentType = EnhancedMimeType.create((String)this.metaContentTypeStr);
        }
        return this.metaContentType;
    }

    public void setMetaContentType(@Nullable EnhancedMimeType metaContentType) {
        this.metaContentType = metaContentType;
        this.metaContentTypeStr = metaContentType == null ? null : metaContentType.toString();
    }

    @Nullable
    public Object getMeta() {
        return this.meta;
    }

    void setMeta(@Nullable Object meta) {
        this.meta = meta;
    }
}

