/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;
import org.fuin.esc.api.DeserializerRegistry;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.jackson.Base64Data;
import org.fuin.esc.jackson.EscJacksonUtils;
import org.fuin.esc.jackson.EscMeta;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Already tested along with the other tests in this package")
public final class EscMetaJacksonDeserializer
extends StdDeserializer<EscMeta> {
    private final DeserializerRegistry deserializerRegistry;

    public EscMetaJacksonDeserializer(DeserializerRegistry deserializerRegistry) {
        super(EscMeta.class);
        this.deserializerRegistry = Objects.requireNonNull(deserializerRegistry, "deserializerRegistry==null");
    }

    public EscMeta deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        EscMeta escMeta = new EscMeta();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        escMeta.setDataType(node.get("data-type").asText());
        escMeta.setDataContentType(EnhancedMimeType.create((String)node.get("data-content-type").asText()));
        if (node.has("meta-type")) {
            escMeta.setMetaType(node.get("meta-type").asText());
            escMeta.setMetaContentType(EnhancedMimeType.create((String)node.get("meta-content-type").asText()));
            JsonNode base64Node = node.get("Base64");
            if (base64Node == null) {
                JsonNode metaNode = node.get(escMeta.getMetaType());
                SerializedDataType metaType = new SerializedDataType(escMeta.getMetaType());
                EnhancedMimeType metaContentType = escMeta.getMetaContentType();
                if (metaContentType == null) {
                    throw new IllegalStateException("Content type for meta is not defined");
                }
                Object meta = EscJacksonUtils.deserialize(metaNode, metaType, metaContentType, this.deserializerRegistry);
                escMeta.setMeta(meta);
            } else {
                escMeta.setMeta(new Base64Data(base64Node.asText()));
            }
        }
        return escMeta;
    }
}

