/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.SerializerRegistry;
import org.fuin.esc.jackson.Base64Data;
import org.fuin.esc.jackson.EscJacksonUtils;
import org.fuin.esc.jackson.EscMeta;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Already tested along with the other tests in this package")
public final class EscMetaJacksonSerializer
extends StdSerializer<EscMeta> {
    private final SerializerRegistry serializerRegistry;

    public EscMetaJacksonSerializer(SerializerRegistry serializerRegistry) {
        super(EscMeta.class);
        this.serializerRegistry = Objects.requireNonNull(serializerRegistry, "serializerRegistry==null");
    }

    public void serialize(EscMeta escMeta, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("data-type", escMeta.getDataType());
        generator.writeStringField("data-content-type", escMeta.getDataContentType().toString());
        if (escMeta.getMeta() != null) {
            generator.writeStringField("meta-type", escMeta.getMetaType());
            generator.writeStringField("meta-content-type", Objects.requireNonNull(escMeta.getMetaContentType()).toString());
            Object object = escMeta.getMeta();
            if (object instanceof Base64Data) {
                Base64Data base64data = (Base64Data)object;
                generator.writeStringField("Base64", base64data.getEncoded());
            } else {
                provider.defaultSerializeField(escMeta.getMetaType(), escMeta.getMeta(), generator);
                SerializedDataType serDataType = new SerializedDataType(escMeta.getMetaType());
                EscJacksonUtils.serialize(generator, this.serializerRegistry, serDataType, escMeta.getMetaType(), escMeta.getMeta());
            }
        }
        generator.writeEndObject();
    }
}

