/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.SerDeserializer;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.SerializedDataTypeRegistry;
import org.fuin.objects4j.jackson.ImmutableObjectMapper;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Test implicitly with other tests")
public final class JacksonSerDeserializer
implements SerDeserializer,
Closeable {
    private final EnhancedMimeType mimeType;
    private final ImmutableObjectMapper.Provider mapperProvider;
    private final SerializedDataTypeRegistry typeRegistry;

    private JacksonSerDeserializer(@NotNull ImmutableObjectMapper.Provider mapperProvider, @NotNull SerializedDataTypeRegistry typeRegistry, @NotNull Charset encoding) {
        Objects.requireNonNull(mapperProvider, "mapperProvider==null");
        Objects.requireNonNull(typeRegistry, "typeRegistry==null");
        Objects.requireNonNull(encoding, "encoding==null");
        this.mapperProvider = mapperProvider;
        this.typeRegistry = typeRegistry;
        this.mimeType = EnhancedMimeType.create((String)"application", (String)"json", (Charset)encoding);
    }

    public EnhancedMimeType getMimeType() {
        return this.mimeType;
    }

    public byte[] marshal(@NotNull Object obj, @NotNull SerializedDataType type) {
        Objects.requireNonNull(obj, "obj==null");
        Objects.requireNonNull(type, "type==null");
        try {
            Class clasz = this.typeRegistry.findClass(type);
            if (!obj.getClass().isAssignableFrom(clasz)) {
                throw new IllegalStateException("The instance class '" + obj.getClass().getName() + "' is not assignable from '" + clasz.getName() + "'. The registry returned an incompatible type for '" + String.valueOf(type) + "'");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, this.mimeType.getEncoding());
            this.mapperProvider.writer().writeValue((Writer)writer, obj);
            return bos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error serializing data", ex);
        }
    }

    public <T> T unmarshal(@NotNull Object data, @NotNull SerializedDataType type, @NotNull EnhancedMimeType mimeType) {
        Objects.requireNonNull(data, "data==null");
        Objects.requireNonNull(type, "type==null");
        Objects.requireNonNull(mimeType, "mimeType==null");
        if (!mimeType.getBaseType().equals(this.mimeType.getBaseType())) {
            throw new IllegalArgumentException("Cannot handle: " + String.valueOf(mimeType));
        }
        try {
            Class clasz = this.typeRegistry.findClass(type);
            if (clasz.isAssignableFrom(data.getClass())) {
                return (T)data;
            }
            if (data instanceof byte[]) {
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])data), mimeType.getEncoding());
                return (T)this.mapperProvider.reader().readValue((Reader)reader, clasz);
            }
            throw new IllegalArgumentException("Expected data to be of type byte[], but was: " + data.getClass().getName());
        }
        catch (IOException ex) {
            String dataStr = new String((byte[])data, mimeType.getEncoding());
            throw new RuntimeException("Error de-serializing data of type '" + String.valueOf(type) + "': " + dataStr, ex);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @NotNull
    public ImmutableObjectMapper mapper() {
        return this.mapperProvider.mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableObjectMapper.Provider mapperProvider;
        private SerializedDataTypeRegistry typeRegistry;
        private Charset encoding = StandardCharsets.UTF_8;

        public Builder withObjectMapper(ImmutableObjectMapper.Provider mapperProvider) {
            this.mapperProvider = mapperProvider;
            return this;
        }

        public Builder withTypeRegistry(SerializedDataTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
            return this;
        }

        public Builder withEncoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public JacksonSerDeserializer build() {
            return new JacksonSerDeserializer(this.mapperProvider, this.typeRegistry, this.encoding);
        }
    }
}

