/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.mem;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.EventNotFoundException;
import org.fuin.esc.api.ExpectedVersion;
import org.fuin.esc.api.StreamAlreadyExistsException;
import org.fuin.esc.api.StreamDeletedException;
import org.fuin.esc.api.StreamEventsSlice;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.StreamNotFoundException;
import org.fuin.esc.api.StreamReadOnlyException;
import org.fuin.esc.api.StreamState;
import org.fuin.esc.api.Subscription;
import org.fuin.esc.api.WrongExpectedVersionException;
import org.fuin.esc.mem.IInMemoryEventStore;
import org.fuin.esc.mem.InMemorySubscription;
import org.fuin.esc.spi.AbstractReadableEventStore;
import org.fuin.esc.spi.EscSpiUtils;
import org.fuin.objects4j.common.Contract;

public final class InMemoryEventStore
extends AbstractReadableEventStore
implements IInMemoryEventStore {
    private final Executor executor;
    private final Map<String, InternalStream> streams;
    private final Map<String, List<InternalSubscription>> subscriptions;
    private boolean open;

    public InMemoryEventStore(@NotNull Executor executor) {
        Contract.requireArgNotNull((String)"executor", (Object)executor);
        this.executor = executor;
        this.streams = new HashMap<String, InternalStream>();
        this.subscriptions = new HashMap<String, List<InternalSubscription>>();
        this.open = false;
    }

    public InMemoryEventStore open() {
        if (this.open) {
            return this;
        }
        this.open = true;
        return this;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
    }

    public boolean isSupportsCreateStream() {
        return false;
    }

    public void createStream(StreamId streamId) throws StreamAlreadyExistsException {
    }

    public boolean streamExists(StreamId streamId) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        this.ensureOpen();
        InternalStream internalStream = this.streams.get(streamId.asString());
        return internalStream != null && internalStream.getState() == StreamState.ACTIVE;
    }

    public CommonEvent readEvent(StreamId streamId, long eventNumber) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgMin((String)"eventNumber", (long)eventNumber, (long)0L);
        this.ensureOpen();
        List<CommonEvent> events = this.getStream(streamId, ExpectedVersion.ANY.getNo()).getEvents();
        if ((long)(events.size() - 1) < eventNumber) {
            throw new EventNotFoundException(streamId, eventNumber);
        }
        return events.get((int)eventNumber);
    }

    public StreamEventsSlice readEventsForward(StreamId streamId, long start, int count) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgMin((String)"start", (long)start, (long)0L);
        Contract.requireArgMin((String)"count", (long)count, (long)1L);
        this.ensureOpen();
        List<CommonEvent> events = this.getStream(streamId, ExpectedVersion.ANY.getNo()).getEvents();
        ArrayList<CommonEvent> result = new ArrayList<CommonEvent>();
        for (int i = (int)start; (long)i < start + (long)count && i < events.size(); ++i) {
            result.add(events.get(i));
        }
        long fromEventNumber = start;
        long nextEventNumber = start + (long)result.size();
        boolean endOfStream = result.size() < count;
        return new StreamEventsSlice(fromEventNumber, result, nextEventNumber, endOfStream);
    }

    public StreamEventsSlice readEventsBackward(StreamId streamId, long start, int count) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgMin((String)"start", (long)start, (long)0L);
        Contract.requireArgMin((String)"count", (long)count, (long)1L);
        this.ensureOpen();
        List<CommonEvent> events = this.getStream(streamId, ExpectedVersion.ANY.getNo()).getEvents();
        ArrayList<CommonEvent> result = new ArrayList<CommonEvent>();
        if (start < (long)events.size()) {
            for (int i = (int)start; (long)i > start - (long)count && i >= 0; --i) {
                result.add(events.get(i));
            }
        }
        long fromEventNumber = start;
        long nextEventNumber = start - (long)result.size();
        if (nextEventNumber < 0L) {
            nextEventNumber = 0L;
        }
        boolean endOfStream = start - (long)count < 0L;
        return new StreamEventsSlice(fromEventNumber, result, nextEventNumber, endOfStream);
    }

    public void deleteStream(StreamId streamId, long expected, boolean hardDelete) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        this.ensureOpen();
        if (streamId.isProjection()) {
            throw new StreamReadOnlyException(streamId);
        }
        InternalStream stream = this.streams.get(streamId.asString());
        if (stream == null) {
            if (expected == ExpectedVersion.ANY.getNo() || expected == ExpectedVersion.NO_OR_EMPTY_STREAM.getNo()) {
                if (hardDelete) {
                    InternalStream hds = new InternalStream();
                    hds.delete(hardDelete);
                    this.streams.put(streamId.asString(), hds);
                }
                return;
            }
            throw new WrongExpectedVersionException(streamId, Long.valueOf(expected), null);
        }
        if (stream.getState() == StreamState.SOFT_DELETED) {
            return;
        }
        if (stream.getState() == StreamState.HARD_DELETED) {
            throw new StreamDeletedException(streamId);
        }
        if (expected != ExpectedVersion.ANY.getNo() && expected != stream.getVersion()) {
            throw new WrongExpectedVersionException(streamId, Long.valueOf(expected), Long.valueOf(stream.getVersion()));
        }
        stream.delete(hardDelete);
    }

    public void deleteStream(StreamId streamId, boolean hardDelete) {
        this.deleteStream(streamId, ExpectedVersion.ANY.getNo(), hardDelete);
    }

    public long appendToStream(StreamId streamId, long expectedVersion, List<CommonEvent> toAppend) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgNotNull((String)"toAppend", toAppend);
        this.ensureOpen();
        if (streamId.isProjection()) {
            throw new StreamReadOnlyException(streamId);
        }
        InternalStream stream = this.streams.get(streamId.asString());
        if (stream == null) {
            stream = new InternalStream();
            this.streams.put(streamId.asString(), stream);
        }
        if (stream.getState() == StreamState.HARD_DELETED) {
            throw new StreamDeletedException(streamId);
        }
        if (stream.getState() == StreamState.SOFT_DELETED) {
            stream.undelete();
        }
        if (expectedVersion != ExpectedVersion.ANY.getNo() && expectedVersion != stream.getVersion()) {
            StreamEventsSlice slice = this.readEventsBackward(streamId, stream.getVersion(), toAppend.size());
            List events = slice.getEvents();
            if (EscSpiUtils.eventsEqual((List)events, toAppend)) {
                return stream.getVersion();
            }
            throw new WrongExpectedVersionException(streamId, Long.valueOf(expectedVersion), Long.valueOf(stream.getVersion()));
        }
        stream.addAll(toAppend);
        this.notifyListeners(streamId, toAppend, 0L);
        return stream.getVersion();
    }

    public long appendToStream(StreamId streamId, long expectedVersion, CommonEvent ... events) {
        return this.appendToStream(streamId, expectedVersion, EscSpiUtils.asList((Object[])events));
    }

    public long appendToStream(StreamId streamId, List<CommonEvent> toAppend) {
        return this.appendToStream(streamId, ExpectedVersion.ANY.getNo(), toAppend);
    }

    public long appendToStream(StreamId streamId, CommonEvent ... events) {
        Contract.requireArgNotNull((String)"events", (Object)events);
        return this.appendToStream(streamId, EscSpiUtils.asList((Object[])events));
    }

    public Subscription subscribeToStream(StreamId streamId, long eventNumber, BiConsumer<Subscription, CommonEvent> onEvent, BiConsumer<Subscription, Exception> onDrop) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgNotNull((String)"onEvent", onEvent);
        Contract.requireArgNotNull((String)"onDrop", onDrop);
        this.ensureOpen();
        List<CommonEvent> events = this.getStream(streamId, ExpectedVersion.ANY.getNo()).getEvents();
        long lastEventNumber = events.size();
        int subscriberId = this.subscriptions.size();
        InMemorySubscription subscription = new InMemorySubscription(subscriberId, streamId, lastEventNumber);
        List<InternalSubscription> list = this.subscriptions.get(streamId.asString());
        if (list == null) {
            list = new ArrayList<InternalSubscription>();
            this.subscriptions.put(streamId.asString(), list);
        }
        list.add(new InternalSubscription(subscription, onEvent));
        this.notifyListeners(streamId, events, eventNumber);
        return subscription;
    }

    public void unsubscribeFromStream(Subscription subscription) {
        int idx;
        Contract.requireArgNotNull((String)"subscription", (Object)subscription);
        this.ensureOpen();
        if (!(subscription instanceof InMemorySubscription)) {
            throw new IllegalArgumentException("Can only handle subscriptions of type " + InMemorySubscription.class.getSimpleName() + ", not: ");
        }
        InMemorySubscription inMemSubscription = (InMemorySubscription)subscription;
        List<InternalSubscription> list = this.subscriptions.get(subscription.getStreamId().asString());
        if (list != null && (idx = this.indexOf(list, inMemSubscription)) > -1) {
            list.remove(idx);
        }
    }

    public StreamState streamState(StreamId streamId) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        this.ensureOpen();
        InternalStream stream = this.streams.get(streamId.asString());
        if (stream == null) {
            throw new StreamNotFoundException(streamId);
        }
        StreamState state = stream.getState();
        if (state == StreamState.SOFT_DELETED) {
            throw new StreamNotFoundException(streamId);
        }
        return state;
    }

    private void ensureOpen() {
        if (!this.open) {
            this.open();
        }
    }

    private void notifyListeners(StreamId streamId, List<CommonEvent> events, long idx) {
        List<InternalSubscription> internalSubscriptions;
        if (idx > -1L && idx < (long)events.size() && (internalSubscriptions = this.subscriptions.get(streamId.asString())) != null) {
            for (InternalSubscription internalSubscription : internalSubscriptions) {
                BiConsumer<Subscription, CommonEvent> eventListener = internalSubscription.getEventListener();
                InMemorySubscription subscription = internalSubscription.getSubscription();
                ArrayList<CommonEvent> copy = new ArrayList<CommonEvent>(events);
                this.executor.execute(() -> {
                    for (long i = idx; i < (long)copy.size(); ++i) {
                        eventListener.accept(subscription, (CommonEvent)copy.get((int)i));
                    }
                });
            }
        }
    }

    private int indexOf(List<InternalSubscription> list, InMemorySubscription inMemSubscription) {
        return list.indexOf(new InternalSubscription(inMemSubscription));
    }

    private InternalStream getStream(StreamId streamId, long expected) {
        InternalStream stream = this.streams.get(streamId.asString());
        if (stream == null) {
            throw new StreamNotFoundException(streamId);
        }
        if (stream.getState() == StreamState.SOFT_DELETED) {
            throw new StreamNotFoundException(streamId);
        }
        if (stream.getState() == StreamState.HARD_DELETED) {
            throw new StreamDeletedException(streamId);
        }
        if (expected != ExpectedVersion.ANY.getNo() && expected != stream.getVersion()) {
            throw new WrongExpectedVersionException(streamId, Long.valueOf(expected), Long.valueOf(stream.getVersion()));
        }
        return stream;
    }

    private static final class InternalStream {
        private StreamState state = StreamState.ACTIVE;
        private int version = -1;
        private final List<CommonEvent> events = new ArrayList<CommonEvent>();

        public void addAll(List<CommonEvent> events) {
            this.events.addAll(events);
            this.version += events.size();
        }

        public StreamState getState() {
            return this.state;
        }

        public long getVersion() {
            return this.version;
        }

        public List<CommonEvent> getEvents() {
            return Collections.unmodifiableList(this.events);
        }

        public void delete(boolean hardDelete) {
            this.state = hardDelete ? StreamState.HARD_DELETED : StreamState.SOFT_DELETED;
            this.events.clear();
        }

        public void undelete() {
            if (this.state != StreamState.SOFT_DELETED) {
                throw new IllegalStateException("Undelete impossible, state was: " + String.valueOf(this.state));
            }
            this.state = StreamState.ACTIVE;
        }
    }

    private static final class InternalSubscription {
        private final InMemorySubscription subscription;
        private final BiConsumer<Subscription, CommonEvent> eventListener;

        public InternalSubscription(InMemorySubscription subscription) {
            this(subscription, null);
        }

        public InternalSubscription(InMemorySubscription subscription, BiConsumer<Subscription, CommonEvent> eventListener) {
            this.subscription = subscription;
            this.eventListener = eventListener;
        }

        public int hashCode() {
            return this.subscription.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof InternalSubscription)) {
                return false;
            }
            InternalSubscription other = (InternalSubscription)obj;
            return this.subscription.equals(other.subscription);
        }

        public InMemorySubscription getSubscription() {
            return this.subscription;
        }

        public BiConsumer<Subscription, CommonEvent> getEventListener() {
            return this.eventListener;
        }
    }
}

