/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.nio.charset.Charset;
import javax.json.Json;
import javax.json.JsonObject;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.codec.binary.Base64;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.JsonDeSerializer;
import org.fuin.esc.spi.SerDeserializer;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.ToJsonCapable;
import org.fuin.objects4j.common.Contract;

@XmlRootElement(name="Base64")
public final class Base64Data
implements ToJsonCapable {
    public static final String EL_ROOT_NAME = "Base64";
    public static final TypeName TYPE = new TypeName("Base64");
    public static final SerializedDataType SER_TYPE = new SerializedDataType(TYPE.asBaseType());
    @XmlValue
    private String base64Str;
    @XmlTransient
    private byte[] binaryData;

    protected Base64Data() {
    }

    public Base64Data(@NotNull String base64Str) {
        Contract.requireArgNotNull((String)"base64Str", (Object)base64Str);
        this.base64Str = base64Str;
        this.binaryData = Base64.decodeBase64((String)base64Str);
    }

    public Base64Data(@NotNull byte[] binaryData) {
        Contract.requireArgNotNull((String)"binaryData", (Object)binaryData);
        this.base64Str = Base64.encodeBase64String((byte[])binaryData);
        this.binaryData = binaryData;
    }

    public final String getEncoded() {
        return this.base64Str;
    }

    public final byte[] getDecoded() {
        if (this.binaryData == null) {
            this.binaryData = Base64.decodeBase64((String)this.base64Str);
        }
        return this.binaryData;
    }

    public final JsonObject toJson() {
        return Json.createObjectBuilder().add(EL_ROOT_NAME, this.base64Str).build();
    }

    public static Base64Data create(JsonObject jsonObj) {
        String base64Str = jsonObj.getString(EL_ROOT_NAME);
        return new Base64Data(base64Str);
    }

    public static class Base64DataJsonDeSerializer
    implements SerDeserializer {
        private final JsonDeSerializer jsonDeSer;

        public Base64DataJsonDeSerializer() {
            this.jsonDeSer = new JsonDeSerializer();
        }

        public Base64DataJsonDeSerializer(Charset encoding) {
            this.jsonDeSer = new JsonDeSerializer(encoding);
        }

        @Override
        public final EnhancedMimeType getMimeType() {
            return this.jsonDeSer.getMimeType();
        }

        @Override
        public final <T> byte[] marshal(T obj, SerializedDataType type) {
            return this.jsonDeSer.marshal((Object)obj, type);
        }

        public final Base64Data unmarshal(Object data, SerializedDataType type, EnhancedMimeType mimeType) {
            JsonObject jsonObj = (JsonObject)this.jsonDeSer.unmarshal(data, type, mimeType);
            return Base64Data.create(jsonObj);
        }
    }
}

