/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.spi.Base64Data;
import org.fuin.esc.spi.DataWrapper;
import org.fuin.esc.spi.Deserializer;
import org.fuin.esc.spi.DeserializerRegistry;
import org.fuin.esc.spi.DeserializerRegistryRequired;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.EscMeta;
import org.fuin.esc.spi.JsonDeSerializer;
import org.fuin.esc.spi.SerDeserializer;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.ToJsonCapable;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Nullable;

@XmlRootElement(name="Event")
public final class EscEvent
implements ToJsonCapable {
    public static final String EL_ROOT_NAME = "Event";
    private static final String EL_EVENT_ID = "EventId";
    private static final String EL_EVENT_TYPE = "EventType";
    private static final String EL_DATA = "Data";
    private static final String EL_META_DATA = "MetaData";
    public static final TypeName TYPE = new TypeName("Event");
    public static final SerializedDataType SER_TYPE = new SerializedDataType(TYPE.asBaseType());
    @XmlElement(name="EventId")
    private String eventId;
    @XmlElement(name="EventType")
    private String eventType;
    @XmlElement(name="Data")
    private DataWrapper data;
    @XmlElement(name="MetaData")
    private DataWrapper meta;

    protected EscEvent() {
    }

    public EscEvent(@NotNull UUID eventId, @NotNull String eventType, @NotNull DataWrapper data) {
        this(eventId, eventType, data, null);
    }

    public EscEvent(@NotNull UUID eventId, @NotNull String eventType, @NotNull DataWrapper data, @Nullable DataWrapper meta) {
        Contract.requireArgNotNull((String)"eventId", (Object)eventId);
        Contract.requireArgNotNull((String)"eventType", (Object)eventType);
        Contract.requireArgNotNull((String)"data", (Object)data);
        this.eventId = eventId.toString();
        this.eventType = eventType;
        this.data = data;
        this.meta = meta;
    }

    public final String getEventId() {
        return this.eventId;
    }

    public final String getEventType() {
        return this.eventType;
    }

    public final DataWrapper getData() {
        return this.data;
    }

    public final DataWrapper getMeta() {
        return this.meta;
    }

    public final JsonObject toJson() {
        return Json.createObjectBuilder().add(EL_EVENT_ID, this.eventId).add(EL_EVENT_TYPE, this.eventType).add(EL_DATA, (JsonValue)this.data.toJson()).add(EL_META_DATA, (JsonValue)this.meta.toJson()).build();
    }

    public static EscEvent create(JsonObject jsonObj) {
        String eventId = jsonObj.getString(EL_EVENT_ID);
        String eventType = jsonObj.getString(EL_EVENT_TYPE);
        JsonObject jsonData = jsonObj.getJsonObject(EL_DATA);
        JsonObject jsonMeta = jsonObj.getJsonObject(EL_META_DATA);
        return new EscEvent(UUID.fromString(eventId), eventType, new DataWrapper(jsonData), new DataWrapper(jsonMeta));
    }

    public static final class JsonbDeSer
    implements JsonbSerializer<EscEvent>,
    JsonbDeserializer<EscEvent>,
    DeserializerRegistryRequired {
        private DeserializerRegistry registry;

        public EscEvent deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
            EscEvent escEvent = new EscEvent();
            JsonObject content = null;
            while (parser.hasNext()) {
                String field;
                JsonParser.Event event = parser.next();
                if (event != JsonParser.Event.KEY_NAME) continue;
                switch (field = parser.getString()) {
                    case "EventId": {
                        escEvent.eventId = (String)ctx.deserialize(String.class, parser);
                        break;
                    }
                    case "EventType": {
                        escEvent.eventType = (String)ctx.deserialize(String.class, parser);
                        break;
                    }
                    case "MetaData": {
                        escEvent.meta = new DataWrapper(ctx.deserialize(EscMeta.class, parser));
                        break;
                    }
                    case "Data": {
                        content = (JsonObject)ctx.deserialize(JsonObject.class, parser);
                        break;
                    }
                }
            }
            if (content == null) {
                throw new IllegalStateException("Expected content to be set, but was never processed during parse process");
            }
            if (content.containsKey((Object)"Base64")) {
                escEvent.data = new DataWrapper(new Base64Data(content.getString("Base64")));
            } else {
                if (!(escEvent.meta.getObj() instanceof EscMeta)) {
                    throw new IllegalStateException("Expected 'meta.object' to be of type 'EscMeta', but was: " + escEvent.meta.getObj());
                }
                EscMeta escMeta = (EscMeta)escEvent.meta.getObj();
                Deserializer deserializer = this.registry.getDeserializer(new SerializedDataType(escEvent.eventType), escMeta.getDataContentType());
                Object obj = deserializer.unmarshal(content, new SerializedDataType(escEvent.eventType), escMeta.getDataContentType());
                escEvent.data = new DataWrapper(obj);
            }
            return escEvent;
        }

        public void serialize(EscEvent obj, JsonGenerator generator, SerializationContext ctx) {
            generator.writeStartObject();
            if (obj != null) {
                generator.write(EscEvent.EL_EVENT_ID, obj.eventId);
                generator.write(EscEvent.EL_EVENT_TYPE, obj.eventType);
                if (obj.getData().getObj() instanceof Base64Data) {
                    Base64Data base64Data = (Base64Data)obj.getData().getObj();
                    generator.writeStartObject(EscEvent.EL_DATA);
                    generator.write("Base64", base64Data.getEncoded());
                    generator.writeEnd();
                } else {
                    ctx.serialize(EscEvent.EL_DATA, obj.getData().getObj(), generator);
                }
                ctx.serialize(EscEvent.EL_META_DATA, obj.getMeta().getObj(), generator);
            }
            generator.writeEnd();
        }

        @Override
        public void setRegistry(DeserializerRegistry registry) {
            this.registry = registry;
        }
    }

    public static class EscEventJsonDeSerializer
    implements SerDeserializer {
        private JsonDeSerializer jsonDeSer;

        public EscEventJsonDeSerializer() {
            this.jsonDeSer = new JsonDeSerializer();
        }

        public EscEventJsonDeSerializer(Charset encoding) {
            this.jsonDeSer = new JsonDeSerializer(encoding);
        }

        @Override
        public final EnhancedMimeType getMimeType() {
            return this.jsonDeSer.getMimeType();
        }

        @Override
        public final <T> byte[] marshal(T obj, SerializedDataType type) {
            return this.jsonDeSer.marshal((Object)obj, type);
        }

        public final EscEvent unmarshal(Object data, SerializedDataType type, EnhancedMimeType mimeType) {
            JsonObject jsonObj = (JsonObject)this.jsonDeSer.unmarshal(data, type, mimeType);
            return EscEvent.create(jsonObj);
        }
    }
}

