/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.json.JsonStructure;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.config.PropertyNamingStrategy;
import javax.json.bind.config.PropertyVisibilityStrategy;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import org.fuin.esc.spi.DeserializerRegistry;
import org.fuin.esc.spi.DeserializerRegistryRequired;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.SerDeserializer;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.SerializedDataTypeRegistry;
import org.fuin.esc.spi.SerializedDataTypeRegistryRequired;
import org.fuin.esc.spi.SerializerRegistry;
import org.fuin.esc.spi.SerializerRegistryRequired;

public final class JsonbDeSerializer
implements SerDeserializer,
Closeable {
    private final EnhancedMimeType mimeType;
    private final Jsonb jsonb;
    private final List<JsonbSerializer<?>> serializers;
    private final List<JsonbDeserializer<?>> deserializers;
    private SerializedDataTypeRegistry typeRegistry;
    private boolean initialized;

    private JsonbDeSerializer(JsonbConfig config, Charset encoding, List<JsonbSerializer<?>> serializers, List<JsonbDeserializer<?>> deserializers) {
        this.jsonb = JsonbBuilder.create((JsonbConfig)config);
        this.mimeType = EnhancedMimeType.create("application", "json", encoding);
        this.serializers = serializers;
        this.deserializers = deserializers;
    }

    @Override
    public final EnhancedMimeType getMimeType() {
        return this.mimeType;
    }

    public final byte[] marshal(Object obj, SerializedDataType type) {
        this.ensureInitialized();
        try {
            Class<?> clasz = this.typeRegistry.findClass(type);
            if (!obj.getClass().isAssignableFrom(clasz)) {
                throw new IllegalStateException("The instance class '" + obj.getClass().getName() + "' is not assignable from '" + clasz.getName() + "'. The registry returned an incompatible type for '" + type + "'");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, this.mimeType.getEncoding());
            this.jsonb.toJson(obj, (Writer)writer);
            return bos.toByteArray();
        }
        catch (JsonbException ex) {
            throw new RuntimeException("Error serializing data", ex);
        }
    }

    @Override
    public final <T> T unmarshal(Object data, SerializedDataType type, EnhancedMimeType mimeType) {
        this.ensureInitialized();
        try {
            Class<?> clasz = this.typeRegistry.findClass(type);
            if (clasz.isAssignableFrom(data.getClass())) {
                return (T)data;
            }
            if (data instanceof JsonStructure) {
                return (T)this.jsonb.fromJson(data.toString(), clasz);
            }
            if (data instanceof byte[]) {
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])data), mimeType.getEncoding());
                return (T)this.jsonb.fromJson((Reader)reader, clasz);
            }
            throw new IllegalArgumentException("Expected data to be of type byte[], but was: " + data.getClass().getName());
        }
        catch (JsonbException ex) {
            throw new RuntimeException("Error de-serializing data", ex);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.jsonb.close();
        }
        catch (Exception ex) {
            throw new IOException("Failed to clode JSONB instance", ex);
        }
    }

    public Jsonb getJsonb() {
        this.ensureInitialized();
        return this.jsonb;
    }

    public void init(SerializedDataTypeRegistry typeRegistry) {
        this.init(typeRegistry, null, null);
    }

    public void init(SerializedDataTypeRegistry typeRegistry, SerializerRegistry serRegistry) {
        this.init(typeRegistry, null, serRegistry);
    }

    public void init(SerializedDataTypeRegistry typeRegistry, DeserializerRegistry deserRegistry) {
        this.init(typeRegistry, deserRegistry, null);
    }

    public void init(SerializedDataTypeRegistry typeRegistry, DeserializerRegistry deserRegistry, SerializerRegistry serRegistry) {
        if (this.initialized) {
            throw new IllegalStateException("Instance already initialized - Don't call the init methods more than once");
        }
        this.typeRegistry = typeRegistry;
        for (JsonbDeserializer<?> jsonbDeserializer : this.deserializers) {
            Object des;
            if (jsonbDeserializer instanceof DeserializerRegistryRequired) {
                if (deserRegistry == null) {
                    throw new IllegalStateException("There is at least one deserializer that requires a 'DeserializerRegistry', but you didn't provide one (deserializer=" + jsonbDeserializer.getClass().getName() + ")");
                }
                des = (DeserializerRegistryRequired)jsonbDeserializer;
                des.setRegistry(deserRegistry);
            }
            if (!(jsonbDeserializer instanceof SerializedDataTypeRegistryRequired)) continue;
            if (typeRegistry == null) {
                throw new IllegalStateException("There is at least one deserializer that requires a 'SerializedDataTypeRegistry', but you didn't provide one (deserializer=" + jsonbDeserializer.getClass().getName() + ")");
            }
            des = (SerializedDataTypeRegistryRequired)jsonbDeserializer;
            des.setRegistry(typeRegistry);
        }
        for (JsonbSerializer jsonbSerializer : this.serializers) {
            Object ser;
            if (jsonbSerializer instanceof SerializerRegistryRequired) {
                if (serRegistry == null) {
                    throw new IllegalStateException("There is at least one serializer that requires a 'SerializerRegistry', but you didn't provide one (serializer=" + jsonbSerializer.getClass().getName() + ")");
                }
                ser = (SerializerRegistryRequired)jsonbSerializer;
                ser.setRegistry(serRegistry);
            }
            if (!(jsonbSerializer instanceof SerializedDataTypeRegistryRequired)) continue;
            if (typeRegistry == null) {
                throw new IllegalStateException("There is at least one serializer that requires a 'SerializedDataTypeRegistry', but you didn't provide one (serializer=" + jsonbSerializer.getClass().getName() + ")");
            }
            ser = (SerializedDataTypeRegistryRequired)jsonbSerializer;
            ser.setRegistry(typeRegistry);
        }
        this.initialized = true;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Please call one of the the 'init' methods before executing other methods");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final JsonbConfig config = new JsonbConfig();
        private final List<JsonbSerializer<?>> serializers = new ArrayList();
        private final List<JsonbDeserializer<?>> deserializers = new ArrayList();
        private Charset encoding;

        public final Builder withFormatting(Boolean formatted) {
            this.config.withFormatting(formatted);
            return this;
        }

        public final Builder withNullValues(Boolean serializeNullValues) {
            this.config.withNullValues(serializeNullValues);
            return this;
        }

        public final Builder withEncoding(Charset encoding) {
            this.config.withEncoding(encoding.name());
            this.encoding = encoding;
            return this;
        }

        public final Builder withStrictIJSON(Boolean enabled) {
            this.config.withStrictIJSON(enabled);
            return this;
        }

        public final Builder withPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
            this.config.withPropertyNamingStrategy(propertyNamingStrategy);
            return this;
        }

        public final Builder withPropertyNamingStrategy(String propertyNamingStrategy) {
            this.config.withPropertyNamingStrategy(propertyNamingStrategy);
            return this;
        }

        public final Builder withPropertyOrderStrategy(String propertyOrderStrategy) {
            this.config.withPropertyOrderStrategy(propertyOrderStrategy);
            return this;
        }

        public final Builder withPropertyVisibilityStrategy(PropertyVisibilityStrategy propertyVisibilityStrategy) {
            this.config.withPropertyVisibilityStrategy(propertyVisibilityStrategy);
            return this;
        }

        public final Builder withAdapters(JsonbAdapter<?, ?> ... adapters) {
            this.config.withAdapters(adapters);
            return this;
        }

        public final Builder withSerializers(JsonbSerializer<?> ... serializers) {
            this.config.withSerializers(serializers);
            this.serializers.addAll(Arrays.asList(serializers));
            return this;
        }

        public final Builder withDeserializers(JsonbDeserializer<?> ... deserializers) {
            this.config.withDeserializers(deserializers);
            this.deserializers.addAll(Arrays.asList(deserializers));
            return this;
        }

        public final Builder withBinaryDataStrategy(String binaryDataStrategy) {
            this.config.withBinaryDataStrategy(binaryDataStrategy);
            return this;
        }

        public final Builder withDateFormat(String dateFormat, Locale locale) {
            this.config.withDateFormat(dateFormat, locale);
            return this;
        }

        public final JsonbDeSerializer build() {
            if (this.encoding == null) {
                this.withEncoding(Charset.forName("UTF-8"));
            }
            return new JsonbDeSerializer(this.config, this.encoding, this.serializers, this.deserializers);
        }
    }
}

