/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.SerDeserializer;
import org.fuin.esc.spi.SerializedDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public final class XmlDeSerializer
implements SerDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDeSerializer.class);
    private final EnhancedMimeType mimeType;
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public XmlDeSerializer(Class<?> ... classesToBeBound) {
        this(Charset.forName("utf-8"), true, classesToBeBound);
    }

    public XmlDeSerializer(boolean jaxbFragment, Class<?> ... classesToBeBound) {
        this(Charset.forName("utf-8"), jaxbFragment, classesToBeBound);
    }

    public XmlDeSerializer(Charset encoding, Class<?> ... classesToBeBound) {
        this(encoding, null, true, classesToBeBound);
    }

    public XmlDeSerializer(Charset encoding, boolean jaxbFragment, Class<?> ... classesToBeBound) {
        this(encoding, null, true, classesToBeBound);
    }

    public XmlDeSerializer(Charset encoding, XmlAdapter<?, ?>[] adapters, boolean jaxbFragment, Class<?> ... classesToBeBound) {
        this.mimeType = EnhancedMimeType.create("application", "xml", encoding);
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound);
            this.marshaller = ctx.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)jaxbFragment);
            this.unmarshaller = ctx.createUnmarshaller();
            if (adapters == null || adapters.length == 0) {
                LOG.debug("No adapters set");
            } else {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    LOG.debug("Set adapter : " + adapter);
                    this.marshaller.setAdapter(adapter);
                    this.unmarshaller.setAdapter(adapter);
                }
            }
            this.unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    if (event.getSeverity() > 0) {
                        if (event.getLinkedException() == null) {
                            throw new RuntimeException("Error unmarshalling the data: " + event.getMessage());
                        }
                        throw new RuntimeException("Error unmarshalling the data", event.getLinkedException());
                    }
                    return true;
                }
            });
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error initializing JAXB helper classes", ex);
        }
    }

    @Override
    public final EnhancedMimeType getMimeType() {
        return this.mimeType;
    }

    public final byte[] marshal(Object obj, SerializedDataType type) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, this.mimeType.getEncoding());
            this.marshaller.marshal(obj, (Writer)writer);
            return bos.toByteArray();
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error serializing data", ex);
        }
    }

    @Override
    public final <T> T unmarshal(Object data, SerializedDataType type, EnhancedMimeType mimeType) {
        try {
            if (data instanceof byte[]) {
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])data), mimeType.getEncoding());
                return (T)this.unmarshaller.unmarshal((Reader)reader);
            }
            if (data instanceof Node) {
                return (T)this.unmarshaller.unmarshal((Node)data);
            }
            return (T)data;
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error de-serializing data", ex);
        }
    }
}

