/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.EscEvent;
import org.fuin.esc.spi.JsonDeSerializer;
import org.fuin.esc.spi.SerDeserializer;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.ToJsonCapable;
import org.fuin.objects4j.common.Contract;

@XmlRootElement(name="Events")
public final class EscEvents
implements ToJsonCapable {
    protected static final String EL_ROOT_NAME = "Events";
    private static final String EL_EVENT = "Event";
    public static final TypeName TYPE = new TypeName("Events");
    public static final SerializedDataType SER_TYPE = new SerializedDataType(TYPE.asBaseType());
    @XmlElement(name="Event")
    private List<EscEvent> list;

    protected EscEvents() {
    }

    public EscEvents(EscEvent ... events) {
        this(Arrays.asList(events));
    }

    public EscEvents(@NotNull List<EscEvent> events) {
        Contract.requireArgNotNull((String)"events", events);
        this.list = events;
    }

    public final List<EscEvent> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public final JsonArray toJson() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (EscEvent event : this.list) {
            builder.add((JsonValue)event.toJson());
        }
        return builder.build();
    }

    public static EscEvents create(JsonArray jsonArray) {
        ArrayList<EscEvent> events = new ArrayList<EscEvent>();
        for (JsonValue jsonValue : jsonArray) {
            if (jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new IllegalArgumentException("All elements in the JSON array must be an JsonObject, but was: " + jsonValue.getValueType());
            }
            events.add(EscEvent.create((JsonObject)jsonValue));
        }
        return new EscEvents(events);
    }

    public static final class JsonbDeSer
    implements JsonbSerializer<EscEvents>,
    JsonbDeserializer<EscEvents> {
        public EscEvents deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
            ArrayList<EscEvent> events = new ArrayList<EscEvent>();
            while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                if (event != JsonParser.Event.START_OBJECT) continue;
                events.add((EscEvent)ctx.deserialize(EscEvent.class, parser));
            }
            return new EscEvents(events);
        }

        public void serialize(EscEvents obj, JsonGenerator generator, SerializationContext ctx) {
            if (obj == null) {
                return;
            }
            generator.writeStartArray();
            if (obj.list != null) {
                for (EscEvent event : obj.list) {
                    ctx.serialize((Object)event, generator);
                }
            }
            generator.writeEnd();
        }
    }

    public static class EscEventsJsonDeSerializer
    implements SerDeserializer {
        private JsonDeSerializer jsonDeSer;

        public EscEventsJsonDeSerializer() {
            this.jsonDeSer = new JsonDeSerializer();
        }

        public EscEventsJsonDeSerializer(Charset encoding) {
            this.jsonDeSer = new JsonDeSerializer(encoding);
        }

        @Override
        public final EnhancedMimeType getMimeType() {
            return this.jsonDeSer.getMimeType();
        }

        @Override
        public final <T> byte[] marshal(T obj, SerializedDataType type) {
            return this.jsonDeSer.marshal((Object)obj, type);
        }

        public final EscEvents unmarshal(Object data, SerializedDataType type, EnhancedMimeType mimeType) {
            JsonArray jsonArray = (JsonArray)this.jsonDeSer.unmarshal(data, type, mimeType);
            return EscEvents.create(jsonArray);
        }
    }
}

