/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.annotation.Nullable;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.reflect.Type;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.spi.Base64Data;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.SerializedDataTypeRegistry;
import org.fuin.esc.spi.SerializedDataTypeRegistryRequired;
import org.fuin.esc.spi.ToJsonCapable;
import org.fuin.objects4j.common.Contract;

@XmlRootElement(name="esc-meta")
public final class EscMeta
implements ToJsonCapable {
    public static final String EL_ROOT_NAME = "esc-meta";
    public static final TypeName TYPE = new TypeName(EscMeta.class.getSimpleName());
    public static final SerializedDataType SER_TYPE = new SerializedDataType(TYPE.asBaseType());
    private static final String EL_DATA_TYPE = "data-type";
    private static final String EL_DATA_CONTENT_TYPE = "data-content-type";
    private static final String EL_META_TYPE = "meta-type";
    private static final String EL_META_CONTENT_TYPE = "meta-content-type";
    @XmlElement(name="data-type")
    private String dataType;
    @XmlElement(name="data-content-type")
    private String dataContentTypeStr;
    @XmlElement(name="meta-type")
    private String metaType;
    @XmlElement(name="meta-content-type")
    private String metaContentTypeStr;
    @XmlAnyElement(lax=true)
    private Object meta;
    @XmlTransient
    private EnhancedMimeType dataContentType;
    @XmlTransient
    private EnhancedMimeType metaContentType;

    protected EscMeta() {
    }

    public EscMeta(@NotNull String dataType, @NotNull EnhancedMimeType dataContentType) {
        this(dataType, dataContentType, null, null, null);
    }

    public EscMeta(@NotNull String dataType, @NotNull EnhancedMimeType dataContentType, @Nullable String metaType, @Nullable EnhancedMimeType metaContentType, @Nullable Object meta) {
        Contract.requireArgNotNull((String)"dataType", (Object)dataType);
        Contract.requireArgNotNull((String)"dataContentType", (Object)((Object)dataContentType));
        this.dataType = dataType;
        this.dataContentType = dataContentType;
        this.dataContentTypeStr = dataContentType.toString();
        this.metaType = metaType;
        this.metaContentType = metaContentType;
        if (metaContentType != null) {
            this.metaContentTypeStr = metaContentType.toString();
        }
        this.meta = meta;
    }

    @Nullable
    public final String getDataType() {
        return this.dataType;
    }

    @NotNull
    public final EnhancedMimeType getDataContentType() {
        if (this.dataContentType == null) {
            this.dataContentType = EnhancedMimeType.create(this.dataContentTypeStr);
        }
        return this.dataContentType;
    }

    @Nullable
    public final String getMetaType() {
        return this.metaType;
    }

    @Nullable
    public final EnhancedMimeType getMetaContentType() {
        if (this.metaContentType == null && this.metaContentTypeStr != null) {
            this.metaContentType = EnhancedMimeType.create(this.metaContentTypeStr);
        }
        return this.metaContentType;
    }

    @NotNull
    public final Object getMeta() {
        return this.meta;
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add(EL_DATA_TYPE, this.dataType);
        builder.add(EL_DATA_CONTENT_TYPE, this.dataContentTypeStr);
        if (this.meta == null) {
            return builder.build();
        }
        builder.add(EL_META_TYPE, this.metaType);
        builder.add(EL_META_CONTENT_TYPE, this.metaContentTypeStr);
        if (this.meta instanceof JsonObject) {
            JsonObject jo = (JsonObject)this.meta;
            return builder.add(this.metaType, (JsonValue)jo).build();
        }
        if (this.meta instanceof ToJsonCapable) {
            ToJsonCapable tjc = (ToJsonCapable)this.meta;
            return builder.add(this.metaType, (JsonValue)tjc.toJson()).build();
        }
        if (this.meta instanceof Base64Data) {
            Base64Data base64data = (Base64Data)this.meta;
            return builder.add(this.metaType, base64data.getEncoded()).build();
        }
        throw new IllegalStateException("Unknown meta object type: " + this.meta.getClass());
    }

    public static EscMeta create(JsonObject jsonObj) {
        String dataType = jsonObj.getString(EL_DATA_TYPE);
        EnhancedMimeType dataContentType = EnhancedMimeType.create(jsonObj.getString(EL_DATA_CONTENT_TYPE));
        if (!jsonObj.containsKey((Object)EL_META_TYPE)) {
            return new EscMeta(jsonObj.getString(EL_DATA_TYPE), dataContentType);
        }
        String metaType = jsonObj.getString(EL_META_TYPE);
        EnhancedMimeType metaContentType = EnhancedMimeType.create(jsonObj.getString(EL_META_CONTENT_TYPE));
        String transferEncoding = metaContentType.getParameter("transfer-encoding");
        if (transferEncoding == null) {
            return new EscMeta(dataType, dataContentType, metaType, metaContentType, jsonObj.get((Object)metaType));
        }
        JsonObject base64obj = jsonObj.getJsonObject(metaType);
        return new EscMeta(dataType, dataContentType, metaType, metaContentType, new Base64Data(base64obj.getString("Base64")));
    }

    public static final class JsonbDeSer
    implements JsonbSerializer<EscMeta>,
    JsonbDeserializer<EscMeta>,
    SerializedDataTypeRegistryRequired {
        private SerializedDataTypeRegistry registry;

        public EscMeta deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
            EscMeta escMeta = new EscMeta();
            block12: while (parser.hasNext()) {
                String field;
                JsonParser.Event event = parser.next();
                if (event != JsonParser.Event.KEY_NAME) continue;
                switch (field = parser.getString()) {
                    case "data-type": {
                        escMeta.dataType = (String)ctx.deserialize(String.class, parser);
                        continue block12;
                    }
                    case "data-content-type": {
                        escMeta.dataContentType = EnhancedMimeType.create((String)ctx.deserialize(String.class, parser));
                        escMeta.dataContentTypeStr = escMeta.dataContentType.toString();
                        continue block12;
                    }
                    case "meta-type": {
                        escMeta.metaType = (String)ctx.deserialize(String.class, parser);
                        continue block12;
                    }
                    case "meta-content-type": {
                        escMeta.metaContentType = EnhancedMimeType.create((String)ctx.deserialize(String.class, parser));
                        if (escMeta.metaContentType == null) continue block12;
                        escMeta.metaContentTypeStr = escMeta.metaContentType.toString();
                        continue block12;
                    }
                }
                if (field.equals("Base64")) {
                    escMeta.meta = new Base64Data((String)ctx.deserialize(String.class, parser));
                    continue;
                }
                Class<?> clasz = this.registry.findClass(new SerializedDataType(escMeta.metaType));
                escMeta.meta = ctx.deserialize(clasz, parser);
            }
            return escMeta;
        }

        public void serialize(EscMeta obj, JsonGenerator generator, SerializationContext ctx) {
            generator.writeStartObject();
            generator.write(EscMeta.EL_DATA_TYPE, obj.dataType);
            generator.write(EscMeta.EL_DATA_CONTENT_TYPE, obj.dataContentTypeStr);
            if (obj.meta != null) {
                generator.write(EscMeta.EL_META_TYPE, obj.metaType);
                generator.write(EscMeta.EL_META_CONTENT_TYPE, obj.metaContentTypeStr);
                if (obj.meta instanceof Base64Data) {
                    Base64Data base64data = (Base64Data)obj.meta;
                    generator.write("Base64", base64data.getEncoded());
                } else {
                    ctx.serialize(obj.metaType, obj.meta, generator);
                }
            }
            generator.writeEnd();
        }

        @Override
        public void setRegistry(SerializedDataTypeRegistry registry) {
            this.registry = registry;
        }
    }
}

