/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.TenantId;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.vo.KeyValue;

public final class TenantStreamId
implements StreamId {
    private static final long serialVersionUID = 1000L;
    private final TenantId tenantId;
    private final StreamId delegate;

    public TenantStreamId(@Nullable TenantId tenantId, @NotNull StreamId streamId) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        this.tenantId = tenantId;
        this.delegate = streamId;
    }

    @NotNull
    public String getName() {
        if (this.tenantId == null) {
            return this.delegate.getName();
        }
        return this.tenantId + "-" + this.delegate.getName();
    }

    public boolean isProjection() {
        return this.delegate.isProjection();
    }

    @NotNull
    public <T> T getSingleParamValue() {
        return (T)this.delegate.getSingleParamValue();
    }

    @NotNull
    public List<KeyValue> getParameters() {
        return this.delegate.getParameters();
    }

    @NotNull
    public String asString() {
        if (this.tenantId == null) {
            return this.delegate.asString();
        }
        return this.tenantId.asString() + "-" + this.delegate.asString();
    }

    @Nullable
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public StreamId getDelegate() {
        return this.delegate;
    }

    public final int hashCode() {
        return this.asString().hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TenantStreamId other = (TenantStreamId)obj;
        return this.asString().equals(other.asString());
    }

    public final String toString() {
        return this.asString();
    }
}

