/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import org.fuin.esc.api.ReadableEventStore;
import org.fuin.esc.api.StreamEventsSlice;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.StreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadableEventStore
implements ReadableEventStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadableEventStore.class);

    public final void readAllEventsForward(StreamId streamId, long startingAtEventNumber, int chunkSize, ReadableEventStore.ChunkEventHandler handler) {
        StreamEventsSlice currentSlice;
        long sliceStart = startingAtEventNumber;
        do {
            try {
                LOG.debug("Read slice: streamId={}, sliceStart={}, sliceCount={}", new Object[]{streamId, sliceStart, chunkSize});
                currentSlice = this.readEventsForward(streamId, sliceStart, chunkSize);
                LOG.debug("Result slice: {}", (Object)currentSlice);
            }
            catch (StreamNotFoundException ex) {
                LOG.debug(ex.getMessage());
                break;
            }
            if (currentSlice.getEvents().size() > 0) {
                handler.handle(currentSlice);
            }
            sliceStart = currentSlice.getNextEventNumber();
        } while (!currentSlice.isEndOfStream());
    }
}

