/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.activation.MimeTypeParseException;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.vo.ValueObject;
import org.fuin.utils4j.jaxb.CDataXmlAdapter;
import org.fuin.utils4j.jaxb.JaxbUtils;

@XmlRootElement(name="data")
@Immutable
public final class Data
implements ValueObject,
Serializable {
    private static final long serialVersionUID = 1000L;
    @NotNull
    @XmlAttribute(name="type")
    private String type;
    @NotNull
    @XmlAttribute(name="mime-type")
    private String mimeType;
    @NotNull
    @XmlValue
    @XmlJavaTypeAdapter(value=CDataXmlAdapter.class)
    private String content;

    protected Data() {
    }

    public Data(@NotNull String type, @NotNull EnhancedMimeType mimeType, @NotNull String content) {
        Contract.requireArgNotNull((String)"type", (Object)type);
        Contract.requireArgNotNull((String)"mimeType", (Object)((Object)mimeType));
        Contract.requireArgNotNull((String)"content", (Object)content);
        this.type = type;
        this.mimeType = mimeType.toString();
        this.content = content;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final EnhancedMimeType getMimeType() {
        return EnhancedMimeType.create(this.mimeType);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public final boolean isXml() {
        return this.getMimeType().getBaseType().equals("application/xml");
    }

    public final boolean isJson() {
        return this.getMimeType().getBaseType().equals("application/json");
    }

    public final boolean isText() {
        return this.getMimeType().getBaseType().equals("text/plain");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T unmarshalContent(JAXBContext ctx) {
        if (!(this.isJson() || this.isXml() || this.isText())) {
            throw new IllegalStateException("Can only unmarshal JSON, XML or TEXT content, not: " + this.mimeType);
        }
        if (this.isJson()) {
            try (JsonReader reader = Json.createReader((Reader)new StringReader(this.content));){
                JsonObject jsonObject = reader.readObject();
                return (T)jsonObject;
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Error parsing json content: '" + this.content + "'", ex);
            }
        }
        if (!this.isXml()) return (T)this.content;
        try {
            return (T)JaxbUtils.unmarshal((JAXBContext)ctx, (String)this.content, null);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Error parsing xml content: '" + this.content + "'", ex);
        }
    }

    public final String toString() {
        return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("mimeType", (Object)this.mimeType).append("content", (Object)this.content).toString();
    }

    public static Data valueOf(String type, Object obj) {
        return new Data(type, Data.mimeType(obj), Data.content(obj));
    }

    private static EnhancedMimeType mimeType(Object obj) {
        try {
            if (obj instanceof JsonObject) {
                return new EnhancedMimeType("application/json; encoding=utf-8");
            }
            return new EnhancedMimeType("application/xml; encoding=utf-8");
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String content(Object obj) {
        if (obj instanceof JsonObject) {
            return obj.toString();
        }
        return JaxbUtils.marshal((Object)obj, (Class[])new Class[]{obj.getClass()});
    }
}

