/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.annotation.Nullable;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.validation.constraints.NotNull;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.spi.Base64Data;
import org.fuin.esc.spi.Deserializer;
import org.fuin.esc.spi.DeserializerRegistry;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.EscEvent;
import org.fuin.esc.spi.EscEvents;
import org.fuin.esc.spi.EscMeta;
import org.fuin.esc.spi.SerializedData;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.Serializer;
import org.fuin.esc.spi.SerializerRegistry;
import org.fuin.objects4j.common.Contract;
import org.w3c.dom.Node;

public final class EscSpiUtils {
    private EscSpiUtils() {
        throw new UnsupportedOperationException("Creating instances of a utility class is not allowed.");
    }

    @Nullable
    public static SerializedData serialize(@NotNull SerializerRegistry registry, @NotNull SerializedDataType type, @Nullable Object data) {
        if (data == null) {
            return null;
        }
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Serializer serializer = registry.getSerializer(type);
        return new SerializedData(type, serializer.getMimeType(), serializer.marshal(data, type));
    }

    @NotNull
    public static <T> T deserialize(@NotNull DeserializerRegistry registry, @NotNull SerializedData data) {
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"data", (Object)data);
        Deserializer deserializer = registry.getDeserializer(data.getType(), data.getMimeType());
        return deserializer.unmarshal(data.getRaw(), data.getType(), data.getMimeType());
    }

    public static EnhancedMimeType mimeType(@NotNull SerializerRegistry registry, @NotNull List<CommonEvent> commonEvents) {
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"commonEvents", commonEvents);
        EnhancedMimeType mimeType = null;
        for (CommonEvent commonEvent : commonEvents) {
            Serializer serializer = registry.getSerializer(new SerializedDataType(commonEvent.getDataType().asBaseType()));
            if (mimeType == null) {
                mimeType = serializer.getMimeType();
                continue;
            }
            if (mimeType.equals((Object)serializer.getMimeType())) continue;
            return null;
        }
        return mimeType;
    }

    public static <T> List<T> asList(T[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.asList(array);
    }

    public static boolean eventsEqual(@Nullable List<CommonEvent> eventsA, @Nullable List<CommonEvent> eventsB) {
        if (eventsA == null && eventsB == null) {
            return true;
        }
        if (eventsA == null && eventsB != null) {
            return false;
        }
        if (eventsA != null && eventsB == null) {
            return false;
        }
        if (eventsA.size() != eventsB.size()) {
            return false;
        }
        int currentIdx = eventsA.size() - 1;
        for (int appendIdx = eventsB.size() - 1; appendIdx >= 0; --appendIdx) {
            CommonEvent append;
            CommonEvent current = eventsA.get(currentIdx);
            if (!current.equals(append = eventsB.get(appendIdx))) {
                return false;
            }
            --currentIdx;
        }
        return true;
    }

    public static EscMeta createEscMeta(@NotNull SerializerRegistry registry, @NotNull EnhancedMimeType targetContentType, @Nullable CommonEvent commonEvent) {
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"targetContentType", (Object)((Object)targetContentType));
        if (commonEvent == null) {
            return null;
        }
        String dataType = commonEvent.getDataType().asBaseType();
        Serializer dataSerializer = registry.getSerializer(new SerializedDataType(dataType));
        EnhancedMimeType dataContentType = EscSpiUtils.contentType(dataSerializer.getMimeType(), targetContentType);
        if (commonEvent.getMeta() == null) {
            return new EscMeta(dataType, dataContentType);
        }
        String metaType = commonEvent.getMetaType().asBaseType();
        SerializedDataType serDataType = new SerializedDataType(metaType);
        Serializer metaSerializer = registry.getSerializer(serDataType);
        if (metaSerializer.getMimeType().matchEncoding(targetContentType)) {
            return new EscMeta(dataType, dataContentType, metaType, metaSerializer.getMimeType(), commonEvent.getMeta());
        }
        byte[] serMeta = metaSerializer.marshal(commonEvent.getMeta(), serDataType);
        EnhancedMimeType metaContentType = EscSpiUtils.contentType(metaSerializer.getMimeType(), targetContentType);
        return new EscMeta(dataType, dataContentType, metaType, metaContentType, new Base64Data(serMeta));
    }

    private static EnhancedMimeType contentType(EnhancedMimeType sourceContentType, EnhancedMimeType targetContentType) {
        if (sourceContentType.matchEncoding(targetContentType)) {
            return sourceContentType;
        }
        return EnhancedMimeType.create(sourceContentType.toString() + "; transfer-encoding=base64");
    }

    public static String nodeToString(Node node) {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            t.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException ex) {
            throw new RuntimeException("Failed to render node", ex);
        }
    }

    public static JsonbSerializer<?>[] createEscJsonbSerializers() {
        return new JsonbSerializer[]{new EscEvents.JsonbDeSer(), new EscEvent.JsonbDeSer(), new EscMeta.JsonbDeSer()};
    }

    public static JsonbSerializer<?>[] joinJsonbSerializers(JsonbSerializer<?>[] serializersA, JsonbSerializer<?> ... serializersB) {
        return EscSpiUtils.joinJsonbSerializerArrays(serializersA, serializersB);
    }

    public static JsonbSerializer<?>[] joinJsonbSerializerArrays(JsonbSerializer<?>[] ... serializerArrays) {
        List<JsonbSerializer<?>> all = EscSpiUtils.joinArrays(serializerArrays);
        return all.toArray(new JsonbSerializer[all.size()]);
    }

    public static JsonbDeserializer<?>[] createEscJsonbDeserializers() {
        return new JsonbDeserializer[]{new EscEvents.JsonbDeSer(), new EscEvent.JsonbDeSer(), new EscMeta.JsonbDeSer()};
    }

    public static JsonbDeserializer<?>[] joinJsonbDeserializers(JsonbDeserializer<?>[] deserializersA, JsonbDeserializer<?> ... deserializersB) {
        return EscSpiUtils.joinJsonbDeserializerArrays(deserializersA, deserializersB);
    }

    public static JsonbDeserializer<?>[] joinJsonbDeserializerArrays(JsonbDeserializer<?>[] ... deserializerArrays) {
        List<JsonbDeserializer<?>> all = EscSpiUtils.joinArrays(deserializerArrays);
        return all.toArray(new JsonbDeserializer[all.size()]);
    }

    @SafeVarargs
    static <T> List<T> joinArrays(T[] ... arrays) {
        ArrayList<T> all = new ArrayList<T>();
        for (T[] array : arrays) {
            for (int j = 0; j < array.length; ++j) {
                all.add(array[j]);
            }
        }
        return all;
    }
}

