/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.spi.TenantStreamId;
import org.fuin.objects4j.common.Contract;

public final class ProjectionJavaScriptBuilder {
    private int count;
    private String projection;
    private StringBuilder sb;

    public ProjectionJavaScriptBuilder(@NotNull TenantStreamId tenantStreamId) {
        Contract.requireArgNotNull((String)"tenantStreamId", (Object)tenantStreamId);
        if (tenantStreamId.getTenantId() == null) {
            this.initAll(tenantStreamId.getDelegate().asString());
        } else {
            this.initCategory(tenantStreamId.getDelegate().asString(), tenantStreamId.getTenantId().asString());
        }
    }

    public ProjectionJavaScriptBuilder(@NotNull StreamId projectionId) {
        Contract.requireArgNotNull((String)"projectionId", (Object)projectionId);
        this.initAll(projectionId.asString());
    }

    public ProjectionJavaScriptBuilder(@NotNull String projection) {
        Contract.requireArgNotNull((String)"projection", (Object)projection);
        this.initAll(projection);
    }

    public ProjectionJavaScriptBuilder(@NotNull StreamId projectionId, @NotNull StreamId categoryId) {
        Contract.requireArgNotNull((String)"projectionId", (Object)projectionId);
        Contract.requireArgNotNull((String)"categoryId", (Object)categoryId);
        this.initCategory(projectionId.asString(), categoryId.asString());
    }

    public ProjectionJavaScriptBuilder(@NotNull String projection, @NotNull String category) {
        Contract.requireArgNotNull((String)"projection", (Object)projection);
        Contract.requireArgNotNull((String)"category", (Object)category);
        this.initCategory(projection, category);
    }

    private void initAll(String projection) {
        this.count = 0;
        this.projection = projection;
        this.sb = new StringBuilder();
        this.sb.append("fromAll().foreachStream().when({");
    }

    private void initCategory(String projection, String category) {
        this.count = 0;
        this.projection = projection;
        this.sb = new StringBuilder();
        this.sb.append("fromCategory('" + category + "').foreachStream().when({");
    }

    public final ProjectionJavaScriptBuilder type(String eventType) {
        if (this.count > 0) {
            this.sb.append(",");
        }
        this.sb.append("'" + eventType + "': function(state, ev) { linkTo('" + this.projection + "', ev); }");
        ++this.count;
        return this;
    }

    public final ProjectionJavaScriptBuilder type(TypeName eventType) {
        return this.type(eventType.asBaseType());
    }

    public final ProjectionJavaScriptBuilder types(List<TypeName> eventTypes) {
        for (TypeName type : eventTypes) {
            this.type(type.asBaseType());
        }
        return this;
    }

    public final String build() {
        if (this.count == 0) {
            throw new IllegalStateException("No types were added. Use 'type(String)' to add at least one event.");
        }
        this.sb.append("})");
        return this.sb.toString();
    }
}

