/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.Deserializer;
import org.fuin.esc.api.DeserializerRegistry;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.IBaseTypeFactory;
import org.fuin.esc.api.IEscMeta;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.Serializer;
import org.fuin.esc.api.SerializerRegistry;
import org.fuin.esc.spi.SerializedData;
import org.fuin.objects4j.common.Contract;

public final class EscSpiUtils {
    private EscSpiUtils() {
        throw new UnsupportedOperationException("Creating instances of a utility class is not allowed.");
    }

    @Nullable
    public static SerializedData serialize(@NotNull SerializerRegistry registry, @NotNull SerializedDataType type, @Nullable Object data) {
        if (data == null) {
            return null;
        }
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"type", (Object)type);
        Serializer serializer = registry.getSerializer(type);
        return new SerializedData(type, serializer.getMimeType(), serializer.marshal(data, type));
    }

    @NotNull
    public static <T> T deserialize(@NotNull DeserializerRegistry registry, @NotNull SerializedData data) {
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"data", (Object)data);
        Deserializer deserializer = registry.getDeserializer(data.getType(), data.getMimeType());
        return (T)deserializer.unmarshal((Object)data.getRaw(), data.getType(), data.getMimeType());
    }

    public static EnhancedMimeType mimeType(@NotNull SerializerRegistry registry, @NotNull List<CommonEvent> commonEvents) {
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"commonEvents", commonEvents);
        EnhancedMimeType mimeType = null;
        for (CommonEvent commonEvent : commonEvents) {
            Serializer serializer = registry.getSerializer(new SerializedDataType(commonEvent.getDataType().asBaseType()));
            if (mimeType == null) {
                mimeType = serializer.getMimeType();
                continue;
            }
            if (mimeType.equals((Object)serializer.getMimeType())) continue;
            return null;
        }
        return mimeType;
    }

    @Nullable
    public static <T> List<T> asList(@Nullable T[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.asList(array);
    }

    public static boolean eventsEqual(@Nullable List<CommonEvent> eventsA, @Nullable List<CommonEvent> eventsB) {
        if (eventsA == null && eventsB == null) {
            return true;
        }
        if (eventsA == null) {
            return false;
        }
        if (eventsB == null) {
            return false;
        }
        if (eventsA.size() != eventsB.size()) {
            return false;
        }
        int currentIdx = eventsA.size() - 1;
        for (int appendIdx = eventsB.size() - 1; appendIdx >= 0; --appendIdx) {
            CommonEvent append;
            CommonEvent current = eventsA.get(currentIdx);
            if (!current.equals(append = eventsB.get(appendIdx))) {
                return false;
            }
            --currentIdx;
        }
        return true;
    }

    public static IEscMeta createEscMeta(@NotNull SerializerRegistry registry, @NotNull IBaseTypeFactory baseTypeFactory, @NotNull EnhancedMimeType targetContentType, @Nullable CommonEvent commonEvent) {
        Contract.requireArgNotNull((String)"registry", (Object)registry);
        Contract.requireArgNotNull((String)"targetContentType", (Object)targetContentType);
        if (commonEvent == null) {
            return null;
        }
        String dataType = commonEvent.getDataType().asBaseType();
        Serializer dataSerializer = registry.getSerializer(new SerializedDataType(dataType));
        EnhancedMimeType dataContentType = EscSpiUtils.contentType(dataSerializer.getMimeType(), targetContentType);
        if (commonEvent.getMeta() == null) {
            return baseTypeFactory.createEscMeta(dataType, dataContentType, null, null, null);
        }
        String metaType = commonEvent.getMetaType().asBaseType();
        SerializedDataType serDataType = new SerializedDataType(metaType);
        Serializer metaSerializer = registry.getSerializer(serDataType);
        if (metaSerializer.getMimeType().matchEncoding(targetContentType)) {
            return baseTypeFactory.createEscMeta(dataType, dataContentType, metaType, metaSerializer.getMimeType(), commonEvent.getMeta());
        }
        byte[] serMeta = metaSerializer.marshal(commonEvent.getMeta(), serDataType);
        EnhancedMimeType metaContentType = EscSpiUtils.contentType(metaSerializer.getMimeType(), targetContentType);
        return baseTypeFactory.createEscMeta(dataType, dataContentType, metaType, metaContentType, (Object)baseTypeFactory.createBase64Data(serMeta));
    }

    private static EnhancedMimeType contentType(EnhancedMimeType sourceContentType, EnhancedMimeType targetContentType) {
        if (sourceContentType.matchEncoding(targetContentType)) {
            return sourceContentType;
        }
        return EnhancedMimeType.create((String)(String.valueOf(sourceContentType) + "; transfer-encoding=base64"));
    }
}

