/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.spi;

import jakarta.validation.constraints.NotNull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.SerDeserializer;
import org.fuin.esc.api.SerializedDataType;

public final class TextDeSerializer
implements SerDeserializer {
    private final EnhancedMimeType mimeType;

    public TextDeSerializer() {
        this(StandardCharsets.UTF_8);
    }

    public TextDeSerializer(@NotNull Charset encoding) {
        this.mimeType = EnhancedMimeType.create((String)"text", (String)"plain", (Charset)encoding);
    }

    public EnhancedMimeType getMimeType() {
        return this.mimeType;
    }

    public byte[] marshal(@NotNull Object obj, @NotNull SerializedDataType type) {
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Can only handle instances of type 'String', but not: " + String.valueOf(obj.getClass()));
        }
        String str = (String)obj;
        return str.getBytes(this.mimeType.getEncoding());
    }

    public <T> T unmarshal(@NotNull Object data, @NotNull SerializedDataType type, @NotNull EnhancedMimeType mimeType) {
        if (data instanceof byte[]) {
            return (T)new String((byte[])data, mimeType.getEncoding());
        }
        if (data instanceof String) {
            return (T)data;
        }
        throw new IllegalArgumentException("This deserializer only supports input of type 'String' and 'byte[]', but was: " + String.valueOf(data));
    }
}

