/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.util.Currency;
import javax.persistence.AttributeConverter;
import org.fuin.objects4j.common.ThreadSafe;
import org.fuin.objects4j.vo.AbstractValueObjectConverter;
import org.fuin.objects4j.vo.CurrencyAmount;
import org.fuin.objects4j.vo.CurrencyAmountStrValidator;

@ThreadSafe
public final class CurrencyAmountConverter
extends AbstractValueObjectConverter<String, CurrencyAmount>
implements AttributeConverter<CurrencyAmount, String> {
    @Override
    public final Class<String> getBaseTypeClass() {
        return String.class;
    }

    @Override
    public final Class<CurrencyAmount> getValueObjectClass() {
        return CurrencyAmount.class;
    }

    @Override
    public final boolean isValid(String value) {
        return CurrencyAmountStrValidator.isValid(value);
    }

    @Override
    public final CurrencyAmount toVO(String value) {
        if (value == null) {
            return null;
        }
        int p = value.indexOf(32);
        if (p == -1) {
            throw new IllegalArgumentException("No space character found in '" + value + "'");
        }
        String amountStr = value.substring(0, p);
        String currencyCode = value.substring(p + 1);
        Currency currency = Currency.getInstance(currencyCode);
        return new CurrencyAmount(amountStr, currency);
    }

    @Override
    public final String fromVO(CurrencyAmount value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

