/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.util.Locale;
import java.util.StringTokenizer;
import javax.persistence.AttributeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.fuin.objects4j.common.ThreadSafe;

@ThreadSafe
public final class LocaleConverter
extends XmlAdapter<String, Locale>
implements AttributeConverter<Locale, String> {
    public final String marshal(Locale value) throws Exception {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public final Locale unmarshal(String value) throws Exception {
        return LocaleConverter.asLocale(value);
    }

    public final String convertToDatabaseColumn(Locale value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public final Locale convertToEntityAttribute(String value) {
        return LocaleConverter.asLocale(value);
    }

    public static Locale asLocale(String value) {
        Locale locale;
        int p = value.indexOf("__");
        if (p > -1) {
            locale = new Locale(value.substring(0, p), null, value.substring(p + 2));
        } else {
            StringTokenizer tok = new StringTokenizer(value, "_");
            if (tok.countTokens() == 1) {
                locale = new Locale(value);
            } else if (tok.countTokens() == 2) {
                locale = new Locale(tok.nextToken(), tok.nextToken());
            } else if (tok.countTokens() == 3) {
                locale = new Locale(tok.nextToken(), tok.nextToken(), tok.nextToken());
            } else {
                throw new IllegalArgumentException("Cannot convert: '" + value + "'");
            }
        }
        return locale;
    }

    public static boolean validLocale(Locale locale) {
        for (Locale found : Locale.getAvailableLocales()) {
            if (!found.equals(locale)) continue;
            return true;
        }
        return false;
    }
}

