/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.DayOfTheWeek;
import org.fuin.objects4j.vo.MultiDayOfTheWeekConverter;
import org.fuin.objects4j.vo.MultiDayOfTheWeekStr;

@Prompt(value="Mon/Tue/Wed-Fri")
@XmlJavaTypeAdapter(value=MultiDayOfTheWeekConverter.class)
@Immutable
public final class MultiDayOfTheWeek
extends AbstractStringValueObject
implements Iterable<DayOfTheWeek> {
    private static final long serialVersionUID = 1000L;
    @NotEmpty
    private final List<DayOfTheWeek> multipleDayOfTheWeek;
    @NotNull
    private final String value;

    public MultiDayOfTheWeek(@NotNull @MultiDayOfTheWeekStr String multipleDayOfTheWeek) {
        Contract.requireArgNotEmpty("multipleDayOfTheWeek", multipleDayOfTheWeek);
        MultiDayOfTheWeek.requireArgValid("multipleDayOfTheWeek", multipleDayOfTheWeek);
        this.multipleDayOfTheWeek = new ArrayList<DayOfTheWeek>();
        StringTokenizer tok = new StringTokenizer(multipleDayOfTheWeek, "/");
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            int p = part.indexOf(45);
            if (p > -1) {
                DayOfTheWeek from = DayOfTheWeek.valueOf(part.substring(0, p));
                DayOfTheWeek to = DayOfTheWeek.valueOf(part.substring(p + 1));
                for (DayOfTheWeek dow : DayOfTheWeek.getPart(from, to)) {
                    this.multipleDayOfTheWeek.add(dow);
                }
                continue;
            }
            this.multipleDayOfTheWeek.add(DayOfTheWeek.valueOf(part));
        }
        Collections.sort(this.multipleDayOfTheWeek);
        this.value = multipleDayOfTheWeek.toUpperCase();
    }

    public MultiDayOfTheWeek(DayOfTheWeek ... dayOfTheWeek) {
        Contract.requireArgNotNull("dayOfTheWeek", dayOfTheWeek);
        if (dayOfTheWeek.length == 0) {
            throw new ConstraintViolationException("The argument 'dayOfTheWeek' cannot be an empty array");
        }
        this.multipleDayOfTheWeek = new ArrayList<DayOfTheWeek>();
        for (DayOfTheWeek dow : dayOfTheWeek) {
            if (dow == null) continue;
            this.multipleDayOfTheWeek.add(dow);
        }
        Collections.sort(this.multipleDayOfTheWeek);
        this.value = MultiDayOfTheWeek.asStr(this.multipleDayOfTheWeek);
    }

    @Override
    @NotEmpty
    public String asBaseType() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Iterator<DayOfTheWeek> iterator() {
        return Collections.unmodifiableList(this.multipleDayOfTheWeek).iterator();
    }

    public MultiDayOfTheWeek compress() {
        if (this.multipleDayOfTheWeek.size() == 1) {
            return this;
        }
        DayOfTheWeek start = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.multipleDayOfTheWeek.size(); ++i) {
            DayOfTheWeek current = this.multipleDayOfTheWeek.get(i);
            if (start == null) {
                if (i > 0) {
                    sb.append("/");
                }
                start = current;
                sb.append(start);
                continue;
            }
            if (i == this.multipleDayOfTheWeek.size() - 1) {
                sb.append(this.separator(start, current));
                sb.append(current);
                continue;
            }
            if (this.multipleDayOfTheWeek.get(i + 1).previous() == current) continue;
            sb.append(this.separator(start, current));
            sb.append(current);
            start = null;
        }
        return new MultiDayOfTheWeek(sb.toString());
    }

    private String separator(DayOfTheWeek start, DayOfTheWeek current) {
        if (current.follows(start)) {
            return "/";
        }
        return "-";
    }

    private static String asStr(List<DayOfTheWeek> days) {
        StringBuilder sb = new StringBuilder();
        for (DayOfTheWeek dow : days) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(dow);
        }
        return sb.toString();
    }

    public static boolean isValid(@Nullable String multiDayOfTheWeeks) {
        if (multiDayOfTheWeeks == null) {
            return true;
        }
        StringTokenizer tok = new StringTokenizer(multiDayOfTheWeeks, "/");
        if (tok.countTokens() == 0) {
            return false;
        }
        ArrayList<DayOfTheWeek> days = new ArrayList<DayOfTheWeek>();
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            int p = part.indexOf(45);
            if (p > -1) {
                DayOfTheWeek to;
                String part1 = part.substring(0, p);
                String part2 = part.substring(p + 1);
                if (!DayOfTheWeek.isValid(part1) || !DayOfTheWeek.isValid(part2)) {
                    return false;
                }
                DayOfTheWeek from = DayOfTheWeek.valueOf(part1);
                if (from == (to = DayOfTheWeek.valueOf(part2)) || from.after(to)) {
                    return false;
                }
                for (DayOfTheWeek dow : DayOfTheWeek.getPart(from, to)) {
                    if (days.contains(dow)) {
                        return false;
                    }
                    days.add(dow);
                }
                continue;
            }
            if (!DayOfTheWeek.isValid(part)) {
                return false;
            }
            DayOfTheWeek dow = DayOfTheWeek.valueOf(part);
            if (days.contains(dow)) {
                return false;
            }
            days.add(dow);
        }
        return true;
    }

    @Nullable
    public static MultiDayOfTheWeek valueOf(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return new MultiDayOfTheWeek(str);
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!MultiDayOfTheWeek.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' does not represent valid days of the week like 'Mon/Tue/Wed-Fri': '" + value + "'");
        }
    }
}

