/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.PasswordConverter;
import org.fuin.objects4j.vo.PasswordStr;
import org.fuin.objects4j.vo.PasswordStrValidator;

@ShortLabel(value="PW")
@Label(value="Password")
@Tooltip(value="Secret password")
@XmlJavaTypeAdapter(value=PasswordConverter.class)
@Immutable
public final class Password
extends AbstractStringValueObject {
    private static final long serialVersionUID = -7745110729063955842L;
    @NotNull
    @PasswordStr
    private String str;

    protected Password() {
    }

    public Password(@NotNull @PasswordStr String password) {
        Contract.requireArgNotEmpty("password", password);
        PasswordStrValidator.requireArgValid("password", password);
        this.str = password.trim();
    }

    @Override
    public final String asBaseType() {
        return this.str;
    }

    public final String toString() {
        return this.asBaseType();
    }
}

