/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.validation.constraints.NotNull;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.vo.AbstractStringValueObject;

@Immutable
public final class SecurityToken
extends AbstractStringValueObject {
    private static final long serialVersionUID = 8737032520847641569L;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final SecureRandom SECURE_RANDOM;
    @NotNull
    private String token = SecurityToken.createSecureRandom();

    @Override
    public final String asBaseType() {
        return this.token;
    }

    public final String toString() {
        return this.asBaseType();
    }

    private static String encodeBase64(byte[] buffer) {
        int l = buffer.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & buffer[i]) >>> 4];
            out[j++] = DIGITS[0xF & buffer[i]];
        }
        return String.copyValueOf(out);
    }

    private static String createSecureRandom() {
        try {
            String no = "" + SECURE_RANDOM.nextInt();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(no.getBytes());
            return SecurityToken.encodeBase64(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
            SECURE_RANDOM.setSeed(System.currentTimeMillis());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

