/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.common;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Nullable;

public final class Contract {
    private static Validator validator;

    public static void setValidator(Validator newValidator) {
        validator = newValidator;
    }

    public static Validator getValidator() {
        if (validator == null) {
            validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return validator;
    }

    private Contract() {
        throw new UnsupportedOperationException("You cannot create an instance of a utility class!");
    }

    public static void requireArgNotNull(@NotNull String name, Object value) throws ConstraintViolationException {
        if (value == null) {
            throw new ConstraintViolationException("The argument '" + name + "' cannot be null");
        }
    }

    public static void requireArgNotEmpty(@NotNull String name, String value) throws ConstraintViolationException {
        Contract.requireArgNotNull(name, value);
        if (value.length() < 1) {
            throw new ConstraintViolationException("The argument '" + name + "' cannot be empty");
        }
    }

    public static void requireArgMaxLength(@NotNull String name, @NotNull String value, int max) throws ConstraintViolationException {
        if (value.length() > max) {
            throw new ConstraintViolationException("Max length of argument '" + name + "' is " + max + ", but was: " + value.length());
        }
    }

    public static void requireArgMinLength(@NotNull String name, @NotNull String value, int min) throws ConstraintViolationException {
        if (value.length() < min) {
            throw new ConstraintViolationException("Min length of argument '" + name + "' is " + min + ", but was: " + value.length());
        }
    }

    public static void requireArgMax(@NotNull String name, @NotNull long value, long max) throws ConstraintViolationException {
        if (value > max) {
            throw new ConstraintViolationException("Max value of argument '" + name + "' is " + max + ", but was: " + value);
        }
    }

    public static void requireArgMin(@NotNull String name, @NotNull long value, long min) throws ConstraintViolationException {
        if (value < min) {
            throw new ConstraintViolationException("Min value of argument '" + name + "' is " + min + ", but was: " + value);
        }
    }

    public static void requireValid(@NotNull Validator validator, @NotNull Object value, Class<?> ... groups) throws ConstraintViolationException {
        Set constraintViolations = validator.validate(value, new Class[0]);
        if (constraintViolations.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ConstraintViolation constraintViolation : constraintViolations) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("[" + constraintViolation.getPropertyPath() + "] " + constraintViolation.getMessage() + " {" + constraintViolation.getInvalidValue() + "}");
            }
            throw new ConstraintViolationException(sb.toString(), constraintViolations);
        }
    }

    public static void requireValid(@NotNull Object value, Class<?> ... groups) throws ConstraintViolationException {
        Contract.requireValid(Contract.getValidator(), value, groups);
    }

    @NotNull
    public static <TYPE> Set<ConstraintViolation<TYPE>> validate(@NotNull Validator validator, @Nullable TYPE value, Class<?> ... groups) {
        if (value == null) {
            return new HashSet<ConstraintViolation<TYPE>>();
        }
        return validator.validate(value, (Class[])groups);
    }

    @NotNull
    public static <TYPE> Set<ConstraintViolation<TYPE>> validate(@Nullable TYPE value, Class<?> ... groups) {
        return Contract.validate(Contract.getValidator(), value, groups);
    }

    public static <T> List<String> asString(@Nullable Set<ConstraintViolation<T>> constraintViolations) {
        if (constraintViolations == null || constraintViolations.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            list.add(Contract.asString(constraintViolation));
        }
        return list;
    }

    public static <T> String asString(@Nullable Set<ConstraintViolation<T>> constraintViolations, @Nullable String separator) {
        if (constraintViolations == null || constraintViolations.isEmpty()) {
            return "";
        }
        String sepStr = separator == null ? ", " : separator;
        StringBuffer sb = new StringBuffer();
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            if (sb.length() > 0) {
                sb.append(sepStr);
            }
            sb.append(Contract.asString(constraintViolation));
        }
        return sb.toString();
    }

    public static <T> String asString(@Nullable ConstraintViolation<T> violation) {
        if (violation == null) {
            return "";
        }
        String className = violation.getRootBeanClass().getSimpleName();
        String propertyPath = violation.getPropertyPath().toString();
        String message = violation.getMessage();
        Object invalidValue = violation.getInvalidValue();
        if (invalidValue == null) {
            return className + "." + propertyPath + " " + message;
        }
        return className + "." + propertyPath + " " + message + " (" + invalidValue + ")";
    }
}

