/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.json.bind.adapter.JsonbAdapter;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Currency;
import org.fuin.objects4j.common.ThreadSafe;
import org.fuin.objects4j.vo.CurrencyStrValidator;

@Converter(autoApply=true)
@ThreadSafe
public final class CurrencyConverter
extends XmlAdapter<String, Currency>
implements AttributeConverter<Currency, String>,
JsonbAdapter<Currency, String> {
    public final boolean isValid(String value) {
        return CurrencyStrValidator.isValid(value);
    }

    public final Currency toVO(String value) {
        if (value == null) {
            return null;
        }
        return Currency.getInstance(value);
    }

    public final String fromVO(Currency value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public final String marshal(Currency value) throws Exception {
        return this.fromVO(value);
    }

    public final Currency unmarshal(String value) throws Exception {
        return this.toVO(value);
    }

    public final String convertToDatabaseColumn(Currency value) {
        return this.fromVO(value);
    }

    public final Currency convertToEntityAttribute(String value) {
        return this.toVO(value);
    }

    public final String adaptToJson(Currency obj) throws Exception {
        return this.fromVO(obj);
    }

    public final Currency adaptFromJson(String str) throws Exception {
        return this.toVO(str);
    }
}

