/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.regex.Pattern;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.HourConverter;
import org.fuin.objects4j.vo.HourStr;

@ShortLabel(value="HH")
@Label(value="Hour")
@Tooltip(value="Hour of a day")
@Prompt(value="23:59")
@XmlJavaTypeAdapter(value=HourConverter.class)
@Immutable
public final class Hour
extends AbstractStringValueObject {
    private static final long serialVersionUID = 1000L;
    private static final Pattern PATTERN = Pattern.compile("^([01]\\d|2[0-3]):?([0-5]\\d)|24:00$");
    private int hourValue;
    private int minuteValue;

    protected Hour() {
    }

    public Hour(@NotNull @HourStr String hour) {
        Contract.requireArgNotEmpty("hour", hour);
        Hour.requireArgValid("hour", hour);
        this.hourValue = Integer.valueOf(hour.substring(0, 2));
        this.minuteValue = Integer.valueOf(hour.substring(3));
    }

    public Hour(int hour, int minute) {
        if (hour < 0 || hour > 24) {
            throw new ConstraintViolationException("The argument 'hour' is not a valid hour (0-24): '" + hour + "'");
        }
        if (minute < 0 || minute > 59) {
            throw new ConstraintViolationException("The argument 'minute' is not a valid minute (0-59): '" + minute + "'");
        }
        if (hour == 24 && minute != 0) {
            throw new ConstraintViolationException("The argument 'minute' must be '0' if the hour is '24': '" + minute + "'");
        }
        this.hourValue = hour;
        this.minuteValue = minute;
    }

    @Override
    @NotEmpty
    public String asBaseType() {
        if (this.hourValue < 10) {
            if (this.minuteValue < 10) {
                return "0" + this.hourValue + ":0" + this.minuteValue;
            }
            return "0" + this.hourValue + ":" + this.minuteValue;
        }
        if (this.minuteValue < 10) {
            return this.hourValue + ":0" + this.minuteValue;
        }
        return this.hourValue + ":" + this.minuteValue;
    }

    public String toString() {
        return this.asBaseType();
    }

    public int toMinutes() {
        return this.hourValue * 60 + this.minuteValue;
    }

    public static boolean isValid(@Nullable String hour) {
        if (hour == null) {
            return true;
        }
        return PATTERN.matcher(hour).matches();
    }

    @Nullable
    public static Hour valueOf(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return new Hour(str);
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!Hour.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' does not represent a valid hour like '00:00' or '23:59' or '24:00': '" + value + "'");
        }
    }
}

