/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.Password;
import org.fuin.objects4j.vo.PasswordSha512Converter;
import org.fuin.objects4j.vo.PasswordSha512Str;
import org.fuin.objects4j.vo.PasswordSha512StrValidator;

@XmlJavaTypeAdapter(value=PasswordSha512Converter.class)
@Immutable
public final class PasswordSha512
extends AbstractStringValueObject {
    private static final long serialVersionUID = -6285061339408965704L;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    @NotNull
    @PasswordSha512Str
    private final String hash;

    public PasswordSha512(@NotNull @PasswordSha512Str String hexEncodedHash) {
        this.hash = hexEncodedHash;
        Contract.requireArgNotEmpty("hexEncodedHash", hexEncodedHash);
        if (!PasswordSha512StrValidator.isValid(hexEncodedHash)) {
            throw new ConstraintViolationException("The argument 'hexEncodedHash' is not valid");
        }
    }

    public PasswordSha512(@NotNull Password password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(password.toString().getBytes());
            this.hash = PasswordSha512.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Failed to create instance", ex);
        }
    }

    private static String toHex(byte[] hash) {
        int l = hash.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & hash[i]) >>> 4];
            out[j++] = DIGITS[0xF & hash[i]];
        }
        return String.copyValueOf(out);
    }

    @Override
    public final String asBaseType() {
        return this.hash;
    }

    public final String toString() {
        return this.asBaseType();
    }
}

