/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.vo.UUIDStr;

public final class UUIDStrValidator
implements ConstraintValidator<UUIDStr, String> {
    public final void initialize(UUIDStr constraintAnnotation) {
    }

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        return UUIDStrValidator.isValid(value);
    }

    public static final boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() != 36) {
            return false;
        }
        try {
            UUID.fromString(value);
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    public static UUID parseArg(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (value.length() != 36) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
        try {
            return UUID.fromString(value);
        }
        catch (RuntimeException ex) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }
}

