/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import java.util.regex.Pattern;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.vo.UserNameStr;

public final class UserNameStrValidator
implements ConstraintValidator<UserNameStr, String> {
    private static final Pattern PATTERN = Pattern.compile("[a-z][0-9a-z_\\-]*");

    public final void initialize(UserNameStr constraintAnnotation) {
    }

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        return UserNameStrValidator.isValid(value);
    }

    public static final boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() < 3 || value.length() > 20) {
            return false;
        }
        return PATTERN.matcher(value.toString()).matches();
    }

    public static void parseArg(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        String trimmed = value.trim().toLowerCase();
        if (!UserNameStrValidator.isValid(trimmed)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + trimmed + "'");
        }
    }
}

