/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.ui;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Field;
import java.util.Locale;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.ui.TextField;

@Immutable
public class TextFieldInfo {
    private final Field field;
    private final int width;

    public TextFieldInfo(@NotNull Field field, int width) {
        Contract.requireArgNotNull("field", field);
        Contract.requireArgNotNull("width", width);
        this.field = field;
        this.width = width;
    }

    public final Field getField() {
        return this.field;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextFieldInfo other = (TextFieldInfo)obj;
        return this.field.equals(other.field);
    }

    public static TextFieldInfo create(@NotNull Field field, @NotNull Locale locale) {
        TextField textField = field.getAnnotation(TextField.class);
        if (textField == null) {
            return null;
        }
        return new TextFieldInfo(field, textField.width());
    }
}

