/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import java.util.Currency;
import java.util.Set;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.vo.CurrencyStr;

public final class CurrencyStrValidator
implements ConstraintValidator<CurrencyStr, String> {
    private static final String EXPRESSION = "[A-Z]{3}";

    public final void initialize(CurrencyStr constraintAnnotation) {
    }

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        return CurrencyStrValidator.isValid(value);
    }

    public static boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0) {
            return false;
        }
        if (!value.matches(EXPRESSION)) {
            return false;
        }
        Set<Currency> currencies = Currency.getAvailableCurrencies();
        for (Currency currency : currencies) {
            if (!currency.getCurrencyCode().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!CurrencyStrValidator.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }
}

