/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.vo.EmailAddressStr;

public final class EmailAddressStrValidator
implements ConstraintValidator<EmailAddressStr, String> {
    public final void initialize(EmailAddressStr annotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        return EmailAddressStrValidator.isValid(value);
    }

    public static boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0) {
            return false;
        }
        try {
            InternetAddress.parse((String)value, (boolean)false);
            return true;
        }
        catch (AddressException ex) {
            return false;
        }
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        String trimmedLowerCaseValue = value.trim().toLowerCase();
        if (!EmailAddressStrValidator.isValid(trimmedLowerCaseValue)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + trimmedLowerCaseValue + "'");
        }
    }
}

