/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.Hour;
import org.fuin.objects4j.vo.HourRange;
import org.fuin.objects4j.vo.HourRangesConverter;
import org.fuin.objects4j.vo.HourRangesStr;

@Prompt(value="09:00-12:00+13:00-17:00")
@XmlJavaTypeAdapter(value=HourRangesConverter.class)
@Immutable
public final class HourRanges
extends AbstractStringValueObject
implements Iterable<HourRange> {
    private static final long serialVersionUID = 1000L;
    @NotEmpty
    private final List<HourRange> ranges;
    private final String value;

    public HourRanges(@NotNull @HourRangesStr String ranges) {
        Contract.requireArgNotEmpty("ranges", ranges);
        HourRanges.requireArgValid("ranges", ranges);
        this.ranges = new ArrayList<HourRange>();
        int openMinutes = 0;
        StringTokenizer tok = new StringTokenizer(ranges, "+");
        while (tok.hasMoreTokens()) {
            HourRange range = new HourRange(tok.nextToken());
            openMinutes += range.getOpenMinutes();
            this.ranges.add(range);
        }
        if (openMinutes > 1440) {
            throw new ConstraintViolationException("The argument 'ranges' cannot contain more than 24 hours (1440 minutes)");
        }
        Collections.sort(this.ranges);
        this.value = HourRanges.asStr(this.ranges);
    }

    public HourRanges(HourRange ... ranges) {
        Contract.requireArgNotNull("ranges", ranges);
        if (ranges.length == 0) {
            throw new ConstraintViolationException("The argument 'hourRange' cannot be an empty array");
        }
        int openMinutes = 0;
        this.ranges = new ArrayList<HourRange>();
        for (HourRange range : ranges) {
            if (range == null) continue;
            openMinutes += range.getOpenMinutes();
            this.ranges.add(range);
        }
        if (openMinutes > 1440) {
            throw new ConstraintViolationException("The argument 'ranges' cannot contain more than 24 hours (1440 minutes)");
        }
        Collections.sort(this.ranges);
        this.value = HourRanges.asStr(this.ranges);
    }

    @Override
    @NotEmpty
    public String asBaseType() {
        return this.value;
    }

    @Override
    public final Iterator<HourRange> iterator() {
        return Collections.unmodifiableList(this.ranges).iterator();
    }

    public final List<HourRanges> normalize() {
        ArrayList<HourRange> today = new ArrayList<HourRange>();
        ArrayList<HourRange> tommorrow = new ArrayList<HourRange>();
        for (HourRange range : this.ranges) {
            List<HourRange> nr = range.normalize();
            if (nr.size() == 1) {
                today.add(nr.get(0));
                continue;
            }
            if (nr.size() == 2) {
                today.add(nr.get(0));
                tommorrow.add(nr.get(1));
                continue;
            }
            throw new IllegalStateException("Normalized hour range returned an unexpected number of elements: " + nr);
        }
        ArrayList<HourRanges> list = new ArrayList<HourRanges>();
        list.add(new HourRanges(today.toArray(new HourRange[today.size()])));
        if (tommorrow.size() > 0) {
            list.add(new HourRanges(tommorrow.toArray(new HourRange[tommorrow.size()])));
        }
        return list;
    }

    public final boolean isNormalized() {
        return this.normalize().size() == 1;
    }

    public final List<Change> diff(HourRanges toOther) {
        HourRanges.ensureSingleDayOnly("from", this);
        HourRanges.ensureSingleDayOnly("to", toOther);
        BitSet thisMinutes = this.toMinutes();
        BitSet otherMinutes = toOther.toMinutes();
        BitSet addedMinutes = new BitSet(1440);
        BitSet removedMinutes = new BitSet(1440);
        for (int i = 0; i < 1440; ++i) {
            if (thisMinutes.get(i) && !otherMinutes.get(i)) {
                removedMinutes.set(i);
            }
            if (thisMinutes.get(i) || !otherMinutes.get(i)) continue;
            addedMinutes.set(i);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        if (!removedMinutes.isEmpty()) {
            HourRanges removed = HourRanges.valueOf(removedMinutes);
            for (HourRange hr : removed) {
                changes.add(new Change(ChangeType.REMOVED, hr));
            }
        }
        if (!addedMinutes.isEmpty()) {
            HourRanges added = HourRanges.valueOf(addedMinutes);
            for (HourRange hr : added) {
                changes.add(new Change(ChangeType.ADDED, hr));
            }
        }
        return changes;
    }

    public final BitSet toMinutes() {
        HourRanges.ensureSingleDayOnly("this", this);
        BitSet minutes = new BitSet(1440);
        for (HourRange range : this.ranges) {
            minutes.or(range.toMinutes());
        }
        return minutes;
    }

    public final boolean overlaps(@NotNull HourRanges other) {
        BitSet thisMinutes = this.toMinutes();
        BitSet otherMinutes = other.toMinutes();
        thisMinutes.and(otherMinutes);
        return !thisMinutes.isEmpty();
    }

    public final boolean openAt(@NotNull HourRange range) {
        Contract.requireArgNotNull("range", range);
        HourRanges.ensureSingleDayOnly("this", this);
        BitSet original = range.toMinutes();
        BitSet anded = range.toMinutes();
        anded.and(this.toMinutes());
        return anded.equals(original);
    }

    @NotNull
    public final HourRanges add(@NotNull HourRanges other) {
        Contract.requireArgNotNull("other", other);
        HourRanges.ensureSingleDayOnly("this", this);
        HourRanges.ensureSingleDayOnly("other", other);
        BitSet thisMinutes = this.toMinutes();
        BitSet otherMinutes = other.toMinutes();
        thisMinutes.or(otherMinutes);
        return HourRanges.valueOf(thisMinutes);
    }

    @Nullable
    public final HourRanges remove(@NotNull HourRanges other) {
        Contract.requireArgNotNull("other", other);
        HourRanges.ensureSingleDayOnly("this", this);
        HourRanges.ensureSingleDayOnly("other", other);
        BitSet thisMinutes = this.toMinutes();
        BitSet otherMinutes = other.toMinutes();
        otherMinutes.flip(0, 1440);
        thisMinutes.and(otherMinutes);
        if (thisMinutes.isEmpty()) {
            return null;
        }
        return HourRanges.valueOf(thisMinutes);
    }

    public final boolean isSimilarTo(HourRanges other) {
        return this.compress().equals(other.compress());
    }

    public final HourRanges compress() {
        List<HourRanges> normalized = this.normalize();
        if (normalized.size() == 1) {
            return HourRanges.valueOf(normalized.get(0).toMinutes());
        }
        if (normalized.size() == 2) {
            HourRanges firstDay = HourRanges.valueOf(normalized.get(0).toMinutes());
            HourRanges secondDay = normalized.get(1);
            if (secondDay.ranges.size() != 1) {
                throw new IllegalStateException("Expected exactly 1 hour range for the seond day, but was " + secondDay.ranges.size() + ": " + secondDay);
            }
            HourRange seondDayHR = secondDay.ranges.get(0);
            ArrayList<HourRange> newRanges = new ArrayList<HourRange>();
            int lastIdx = 0;
            if (firstDay.ranges.size() > 1) {
                lastIdx = firstDay.ranges.size() - 1;
                newRanges.addAll(firstDay.ranges.subList(0, lastIdx));
            }
            HourRange firstDayHR = firstDay.ranges.get(lastIdx);
            newRanges.add(firstDayHR.joinWithNextDay(seondDayHR));
            return new HourRanges(newRanges.toArray(new HourRange[newRanges.size()]));
        }
        throw new IllegalStateException("Normalized hour ranges returned an unexpected number of elements (" + normalized.size() + "): " + normalized);
    }

    public final String toString() {
        return this.asString();
    }

    private static String asStr(List<HourRange> ranges) {
        StringBuilder sb = new StringBuilder();
        for (HourRange range : ranges) {
            if (sb.length() > 0) {
                sb.append("+");
            }
            sb.append(range.toString());
        }
        return sb.toString();
    }

    private static void ensureSingleDayOnly(String name, HourRanges ranges) {
        if (!ranges.isNormalized()) {
            throw new ConstraintViolationException("The given hour ranges spans two days (" + name + "=" + ranges + ") - Please use 'normalize()' method and pass then the hour ranges per day to this method!");
        }
    }

    public static boolean isValid(@Nullable String hourRanges) {
        if (hourRanges == null) {
            return true;
        }
        StringTokenizer tok = new StringTokenizer(hourRanges, "+");
        if (tok.countTokens() == 0) {
            return false;
        }
        while (tok.hasMoreTokens()) {
            String rangeStr = tok.nextToken();
            if (HourRange.isValid(rangeStr)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static HourRanges valueOf(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return new HourRanges(str);
    }

    public static HourRanges valueOf(@Nullable BitSet minutes) {
        return HourRanges.valueOf(minutes, 1440);
    }

    private static HourRanges valueOf(@Nullable BitSet minutes, int max) {
        if (minutes == null) {
            return null;
        }
        if (minutes.length() > max) {
            throw new IllegalArgumentException("Expected bitset length of max. 1440, but was " + minutes.length() + ": " + minutes);
        }
        Integer startHour = null;
        Integer startMinute = null;
        ArrayList<HourRange> ranges = new ArrayList<HourRange>();
        for (int i = 0; i < max; ++i) {
            if (minutes.get(i)) {
                if (startHour != null) continue;
                startHour = i / 60;
                startMinute = i - startHour * 60;
                continue;
            }
            if (startHour == null) continue;
            ranges.add(HourRanges.createHourRange(startHour, startMinute, i));
            startHour = null;
            startMinute = 0;
        }
        if (startHour != null) {
            ranges.add(HourRanges.createHourRange(startHour, startMinute, minutes.length()));
        }
        return new HourRanges(ranges.toArray(new HourRange[ranges.size()]));
    }

    private static HourRange createHourRange(int startHour, int startMinute, int minute) {
        int endHour = minute / 60;
        int endMinute = endHour == 24 ? 0 : minute - endHour * 60;
        return new HourRange(new Hour(startHour, startMinute), new Hour(endHour, endMinute));
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!HourRanges.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' does not represent a valid hour range like '09:00-12:00+13:00-17:00': '" + value + "'");
        }
    }

    public static final class Change {
        private final ChangeType type;
        private final HourRange range;

        public Change(@NotNull ChangeType type, @NotNull HourRange range) {
            Contract.requireArgNotNull("type", (Object)type);
            Contract.requireArgNotNull("range", range);
            this.type = type;
            this.range = range;
        }

        public final ChangeType getType() {
            return this.type;
        }

        public final HourRange getRange() {
            return this.range;
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Change other = (Change)obj;
            if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
                return false;
            }
            return this.type == other.type;
        }

        public final String toString() {
            return this.type + " " + this.range;
        }
    }

    public static enum ChangeType {
        ADDED,
        REMOVED;

    }
}

