/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.vo.TrimmedNotEmpty;
import org.fuin.objects4j.vo.TrimmedNotEmptyValidator;
import org.fuin.objects4j.vo.ValueObject;

@Immutable
public final class KeyValue
implements ValueObject {
    @TrimmedNotEmpty
    private String key;
    private Object value;

    protected KeyValue() {
    }

    public KeyValue(@NotNull @TrimmedNotEmpty String key, Object value) {
        Contract.requireArgNotNull("key", key);
        TrimmedNotEmptyValidator.requireArgValid("key", key);
        this.key = key.trim();
        this.value = value;
    }

    public final String getKey() {
        return this.key;
    }

    public final Object getValue() {
        return this.value;
    }

    public final String getValueString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public static String replace(String message, KeyValue ... keyValue) {
        if (keyValue == null) {
            return message;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (KeyValue kv : keyValue) {
            if (kv.getValue() instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                Collection coll = (Collection)kv.getValue();
                int count = 0;
                for (Object entry : coll) {
                    if (count > 0) {
                        sb.append(", ");
                    }
                    sb.append(KeyValue.nullSafeAsString(entry));
                    ++count;
                }
                map.put(kv.getKey(), sb.toString());
                continue;
            }
            map.put(kv.getKey(), kv.getValueString());
        }
        return KeyValue.replaceVars(message, map);
    }

    private static String nullSafeAsString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }

    public static String replaceVars(String str, Map<String, String> vars) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (vars == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int end = -1;
        int from = 0;
        int start = -1;
        while ((start = str.indexOf("${", from)) > -1) {
            sb.append(str.substring(end + 1, start));
            end = str.indexOf(125, start + 1);
            if (end == -1) {
                sb.append(str.substring(start));
                from = str.length();
                continue;
            }
            String key = str.substring(start + 2, end);
            String value = vars.get(key);
            if (value == null) {
                sb.append("${");
                sb.append(key);
                sb.append("}");
            } else {
                sb.append(value);
            }
            from = end + 1;
        }
        sb.append(str.substring(from));
        return sb.toString();
    }
}

