/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import java.util.StringTokenizer;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.vo.LocaleConverter;
import org.fuin.objects4j.vo.LocaleStr;

public final class LocaleStrValidator
implements ConstraintValidator<LocaleStr, String> {
    public final void initialize(LocaleStr constraintAnnotation) {
    }

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        return LocaleStrValidator.isValid(value);
    }

    public static final boolean isValid(String value) {
        Locale locale;
        if (value == null) {
            return true;
        }
        int p = value.indexOf("__");
        if (p > -1) {
            locale = new Locale(value.substring(0, p), null, value.substring(p + 2));
        } else {
            StringTokenizer tok = new StringTokenizer(value, "_");
            if (tok.countTokens() == 1) {
                locale = new Locale(value);
            } else if (tok.countTokens() == 2) {
                locale = new Locale(tok.nextToken(), tok.nextToken());
            } else if (tok.countTokens() == 3) {
                locale = new Locale(tok.nextToken(), tok.nextToken(), tok.nextToken());
            } else {
                return false;
            }
        }
        return LocaleConverter.validLocale(locale);
    }

    public static Locale parseArg(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        try {
            Locale locale = LocaleConverter.asLocale(value);
            if (!LocaleConverter.validLocale(locale)) {
                throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
            }
            return locale;
        }
        catch (RuntimeException ex) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }
}

