/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import jakarta.json.bind.adapter.JsonbAdapter;
import jakarta.persistence.AttributeConverter;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.vo.AsStringCapable;
import org.fuin.objects4j.vo.ValueOfCapable;

public abstract class ValueObjectStringConverter<TYPE extends AsStringCapable>
extends XmlAdapter<String, TYPE>
implements AttributeConverter<TYPE, String>,
JsonbAdapter<TYPE, String> {
    private final ValueOfCapable<TYPE> vop;

    public ValueObjectStringConverter(@NotNull ValueOfCapable<TYPE> vop) {
        Contract.requireArgNotNull("vop", vop);
        this.vop = vop;
    }

    public final TYPE unmarshal(String value) {
        return (TYPE)((AsStringCapable)this.vop.valueOf(value));
    }

    public final String marshal(TYPE value) {
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public final String convertToDatabaseColumn(TYPE value) {
        return this.marshal(value);
    }

    public final TYPE convertToEntityAttribute(String value) {
        return this.unmarshal(value);
    }

    public final String adaptToJson(TYPE obj) throws Exception {
        if (obj == null) {
            return null;
        }
        return obj.asString();
    }

    public final TYPE adaptFromJson(String str) throws Exception {
        return (TYPE)((AsStringCapable)this.vop.valueOf(str));
    }
}

