/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Currency;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CurrencyJacksonDeserializer
extends StdDeserializer<Currency> {
    public CurrencyJacksonDeserializer() {
        super(Currency.class);
    }

    public Currency deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken currentToken = parser.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
            String value = parser.getText().trim();
            return Currency.getInstance(value);
        }
        if (currentToken.equals((Object)JsonToken.VALUE_NULL)) {
            return null;
        }
        return (Currency)context.handleUnexpectedToken(this.handledType(), parser);
    }
}

