/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public record ImmutableObjectMapper(ObjectMapper objectMapper) {
    public ObjectReader reader() {
        return this.objectMapper.reader();
    }

    public ObjectWriter writer() {
        return this.objectMapper.writer();
    }

    @NotThreadSafe
    public static final class Builder {
        private final ObjectMapper mapper;
        private boolean built;

        public Builder(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper==null");
            this.built = false;
        }

        public void registerModule(Module module) {
            this.ensureNotBuilt();
            this.mapper.registerModule(module);
        }

        public ImmutableObjectMapper build() {
            this.ensureNotBuilt();
            this.built = true;
            return new ImmutableObjectMapper(this.mapper);
        }

        private void ensureNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("The object mapper was already built. Modifications are not allowed anymore.");
            }
        }
    }

    @NotThreadSafe
    public static final class Provider {
        private final Builder builder;
        private ImmutableObjectMapper mapper;

        public Provider(Builder builder) {
            this.builder = Objects.requireNonNull(builder, "builder==null");
        }

        public ImmutableObjectMapper mapper() {
            if (this.mapper == null) {
                this.mapper = this.builder.build();
            }
            return this.mapper;
        }

        public ObjectReader reader() {
            return this.mapper().reader();
        }

        public ObjectWriter writer() {
            return this.mapper().writer();
        }
    }
}

