/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;
import org.fuin.objects4j.core.LocaleHelper;

@ThreadSafe
public final class LocaleJacksonDeserializer
extends StdDeserializer<Locale> {
    public LocaleJacksonDeserializer() {
        super(Locale.class);
    }

    public Locale deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken currentToken = parser.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
            String value = parser.getText().trim();
            return LocaleHelper.asLocale((String)value);
        }
        if (currentToken.equals((Object)JsonToken.VALUE_NULL)) {
            return null;
        }
        return (Locale)context.handleUnexpectedToken(this.handledType(), parser);
    }
}

