/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Objects4JacksonUtils {
    private Objects4JacksonUtils() {
        throw new UnsupportedOperationException("Creating instances of a utility class is not allowed.");
    }

    public static JsonSerializer<?>[] joinJacksonSerializers(JsonSerializer<?>[] serializersA, JsonSerializer<?> ... serializersB) {
        return Objects4JacksonUtils.joinJacksonSerializerArrays(serializersA, serializersB);
    }

    public static JsonSerializer<?>[] joinJacksonSerializerArrays(JsonSerializer<?>[] ... serializerArrays) {
        List<JsonSerializer<?>> all = Objects4JacksonUtils.joinArrays(serializerArrays);
        return all.toArray(new JsonSerializer[0]);
    }

    public static JsonDeserializer<?>[] joinJacksonDeserializers(JsonDeserializer<?>[] deserializersA, JsonDeserializer<?> ... deserializersB) {
        return Objects4JacksonUtils.joinJacksonDeserializerArrays(deserializersA, deserializersB);
    }

    public static JsonDeserializer<?>[] joinJacksonDeserializerArrays(JsonDeserializer<?>[] ... deserializerArrays) {
        List<JsonDeserializer<?>> all = Objects4JacksonUtils.joinArrays(deserializerArrays);
        return all.toArray(new JsonDeserializer[0]);
    }

    @SafeVarargs
    static <T> List<T> joinArrays(T[] ... arrays) {
        ArrayList<T> all = new ArrayList<T>();
        for (T[] array : arrays) {
            all.addAll(Arrays.asList(array));
        }
        return all;
    }

    public static <T> T deserialize(JsonParser jp, DeserializationContext ctxt, String fqnClassName, JsonNode node) {
        try {
            Class<?> clasz = Class.forName(fqnClassName);
            return Objects4JacksonUtils.deserialize(jp, ctxt, clasz, node);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("The class '" + fqnClassName + "' needed to deserialize the node is unknwon: " + String.valueOf(node), ex);
        }
    }

    public static <T> T deserialize(JsonParser jp, DeserializationContext ctxt, Class<?> clasz, JsonNode node) {
        try {
            JavaType javaType = ctxt.getTypeFactory().constructType(clasz);
            JsonDeserializer deserializer = ctxt.findRootValueDeserializer(javaType);
            JsonParser parser = node.traverse(jp.getCodec());
            parser.nextToken();
            return (T)deserializer.deserialize(parser, ctxt);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to deserialize '" + clasz.getName() + "' from: " + String.valueOf(node), ex);
        }
    }
}

