/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class UUIDJacksonDeserializer
extends StdDeserializer<UUID> {
    public UUIDJacksonDeserializer() {
        super(UUID.class);
    }

    public UUID deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken currentToken = parser.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
            String value = parser.getText().trim();
            return UUID.fromString(value);
        }
        if (currentToken.equals((Object)JsonToken.VALUE_NULL)) {
            return null;
        }
        return (UUID)context.handleUnexpectedToken(this.handledType(), parser);
    }
}

