/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.ValueOfCapable;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Already tested with other classes")
public final class ValueObjectStringJacksonDeserializer<TYPE>
extends StdDeserializer<TYPE> {
    private final ValueOfCapable<TYPE> vop;

    public ValueObjectStringJacksonDeserializer(@NotNull Class<TYPE> clasz, @NotNull ValueOfCapable<TYPE> vop) {
        super(clasz);
        Contract.requireArgNotNull((String)"vop", vop);
        this.vop = vop;
    }

    public TYPE deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken currentToken = parser.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
            String value = parser.getText().trim();
            return (TYPE)this.vop.valueOf(value);
        }
        if (currentToken.equals((Object)JsonToken.VALUE_NULL)) {
            return null;
        }
        return (TYPE)context.handleUnexpectedToken(this.handledType(), parser);
    }
}

