/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.junit;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Optional;
import org.fuin.objects4j.common.HasPublicStaticIsValidMethod;
import org.fuin.objects4j.common.HasPublicStaticIsValidMethods;

public final class HasPublicStaticIsValidMethodCondition
extends ArchCondition<JavaClass> {
    public HasPublicStaticIsValidMethodCondition() {
        super("have a public static 'is valid' method with the signature defined by the annotation", new Object[0]);
    }

    public void check(JavaClass clazz, ConditionEvents events) {
        if (clazz.isAnnotatedWith(HasPublicStaticIsValidMethods.class)) {
            HasPublicStaticIsValidMethods annotations = (HasPublicStaticIsValidMethods)clazz.getAnnotationOfType(HasPublicStaticIsValidMethods.class);
            for (HasPublicStaticIsValidMethod annotation : annotations.value()) {
                HasPublicStaticIsValidMethodCondition.verify(clazz, annotation, events);
            }
        } else if (clazz.isAnnotatedWith(HasPublicStaticIsValidMethod.class)) {
            HasPublicStaticIsValidMethodCondition.verify(clazz, (HasPublicStaticIsValidMethod)clazz.getAnnotationOfType(HasPublicStaticIsValidMethod.class), events);
        }
    }

    private static void verify(JavaClass clazz, HasPublicStaticIsValidMethod annotation, ConditionEvents events) {
        JavaMethod method;
        Optional optionalMethod = clazz.tryGetMethod(annotation.method(), new Class[]{annotation.param()});
        boolean satisfied = optionalMethod.isEmpty() ? false : (!(method = (JavaMethod)optionalMethod.get()).getModifiers().contains(JavaModifier.STATIC) ? false : method.getReturnType().getName().equals(Boolean.TYPE.getName()));
        String message = ConditionEvent.createMessage((HasDescription)clazz, (String)("has " + (satisfied ? "a" : "no") + " method: public static boolean " + annotation.method() + "(" + annotation.param().getSimpleName() + ")"));
        events.add((ConditionEvent)new SimpleConditionEvent((Object)clazz, satisfied, message));
    }
}

