/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.junit;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Optional;
import org.fuin.objects4j.common.HasPublicStaticValueOfMethod;
import org.fuin.objects4j.common.HasPublicStaticValueOfMethods;

public final class HasPublicStaticValueOfMethodCondition
extends ArchCondition<JavaClass> {
    public HasPublicStaticValueOfMethodCondition() {
        super("have a public static 'value of' method with the signature defined by the annotation", new Object[0]);
    }

    public void check(JavaClass clazz, ConditionEvents events) {
        if (clazz.isAnnotatedWith(HasPublicStaticValueOfMethods.class)) {
            HasPublicStaticValueOfMethods annotations = (HasPublicStaticValueOfMethods)clazz.getAnnotationOfType(HasPublicStaticValueOfMethods.class);
            for (HasPublicStaticValueOfMethod annotation : annotations.value()) {
                HasPublicStaticValueOfMethodCondition.verify(clazz, annotation, events);
            }
        } else if (clazz.isAnnotatedWith(HasPublicStaticValueOfMethod.class)) {
            HasPublicStaticValueOfMethodCondition.verify(clazz, (HasPublicStaticValueOfMethod)clazz.getAnnotationOfType(HasPublicStaticValueOfMethod.class), events);
        }
    }

    private static void verify(JavaClass clazz, HasPublicStaticValueOfMethod annotation, ConditionEvents events) {
        JavaMethod method;
        Optional optionalMethod = clazz.tryGetMethod(annotation.method(), new Class[]{annotation.param()});
        boolean satisfied = optionalMethod.isEmpty() ? false : (!(method = (JavaMethod)optionalMethod.get()).getModifiers().contains(JavaModifier.STATIC) ? false : method.getReturnType().getName().equals(clazz.getName()));
        String message = ConditionEvent.createMessage((HasDescription)clazz, (String)("has " + (satisfied ? "a" : "no") + " method: public static " + clazz.getSimpleName() + " " + annotation.method() + "(" + annotation.param().getSimpleName() + ")"));
        events.add((ConditionEvent)new SimpleConditionEvent((Object)clazz, satisfied, message));
    }
}

