/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.ui;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.ui.ClassTextInfo;
import org.fuin.objects4j.ui.FieldTextInfo;

public final class AnnotationAnalyzer {
    private static final Map<Class<?>, String> CLASS_NAME_MAP = new HashMap();

    public final ClassTextInfo createClassInfo(@NotNull Class<?> clasz, @NotNull Locale locale, @NotNull Class<? extends Annotation> annotationClasz) {
        Contract.requireArgNotNull((String)"clasz", clasz);
        Contract.requireArgNotNull((String)"locale", (Object)locale);
        Contract.requireArgNotNull((String)"annotationClasz", annotationClasz);
        Annotation annotation = clasz.getAnnotation(annotationClasz);
        if (annotation == null) {
            return null;
        }
        try {
            ResourceBundle bundle = this.getResourceBundle(annotation, locale, clasz);
            String text = this.getText(bundle, annotation, clasz.getSimpleName() + "." + annotationClasz.getSimpleName());
            return new ClassTextInfo(clasz, text);
        }
        catch (MissingResourceException ex) {
            if (this.getValue(annotation).equals("")) {
                return new ClassTextInfo(clasz, null);
            }
            return new ClassTextInfo(clasz, this.getValue(annotation));
        }
    }

    public final List<FieldTextInfo> createFieldInfos(@NotNull Class<?> clasz, @NotNull Locale locale, @NotNull Class<? extends Annotation> annotationClasz) {
        Field[] fields;
        Contract.requireArgNotNull((String)"clasz", clasz);
        Contract.requireArgNotNull((String)"locale", (Object)locale);
        Contract.requireArgNotNull((String)"annotationClasz", annotationClasz);
        ArrayList<FieldTextInfo> infos = new ArrayList<FieldTextInfo>();
        for (Field field : fields = clasz.getDeclaredFields()) {
            String text;
            Annotation annotation = field.getAnnotation(annotationClasz);
            if (annotation == null) continue;
            try {
                ResourceBundle bundle = this.getResourceBundle(annotation, locale, field.getDeclaringClass());
                text = this.getText(bundle, annotation, field.getName() + "." + annotationClasz.getSimpleName());
                infos.add(new FieldTextInfo(field, text));
            }
            catch (MissingResourceException ex) {
                text = this.toNullableString(this.getValue(annotation));
                infos.add(new FieldTextInfo(field, text));
            }
        }
        Class<?> parent = clasz;
        while ((parent = parent.getSuperclass()) != Object.class) {
            infos.addAll(this.createFieldInfos(parent, locale, annotationClasz));
        }
        return infos;
    }

    public final FieldTextInfo createFieldInfo(@NotNull Field field, @NotNull Locale locale, @NotNull Class<? extends Annotation> annotationClasz) {
        Contract.requireArgNotNull((String)"field", (Object)field);
        Contract.requireArgNotNull((String)"locale", (Object)locale);
        Contract.requireArgNotNull((String)"annotationClasz", annotationClasz);
        Annotation annotation = field.getAnnotation(annotationClasz);
        if (annotation == null) {
            return null;
        }
        try {
            ResourceBundle bundle = this.getResourceBundle(annotation, locale, field.getDeclaringClass());
            String text = this.getText(bundle, annotation, field.getName() + "." + annotationClasz.getSimpleName());
            return new FieldTextInfo(field, text);
        }
        catch (MissingResourceException ex) {
            return new FieldTextInfo(field, this.toNullableString(this.getValue(annotation)));
        }
    }

    private String getText(@NotNull ResourceBundle bundle, @NotNull Annotation annotation, @NotNull String defaultKey) {
        Contract.requireArgNotNull((String)"bundle", (Object)bundle);
        Contract.requireArgNotNull((String)"annotation", (Object)annotation);
        Contract.requireArgNotNull((String)"defaultKey", (Object)defaultKey);
        String key = this.getKey(annotation).equals("") ? defaultKey : this.getKey(annotation);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return this.toNullableString(this.getValue(annotation));
        }
    }

    private ResourceBundle getResourceBundle(@NotNull Annotation annotation, @NotNull Locale locale, @NotNull Class<?> clasz) {
        if (this.getBundle(annotation).equals("")) {
            String path = clasz.getPackage().getName().replace('.', '/');
            String baseName = path + "/" + clasz.getSimpleName();
            return ResourceBundle.getBundle(baseName, locale);
        }
        return ResourceBundle.getBundle(this.getBundle(annotation), locale);
    }

    private final String toNullableString(String value) {
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    private String getBundle(Annotation annotation) {
        return (String)AnnotationAnalyzer.invoke(annotation, "bundle");
    }

    private String getValue(Annotation annotation) {
        return (String)AnnotationAnalyzer.invoke(annotation, "value");
    }

    private String getKey(Annotation annotation) {
        return (String)AnnotationAnalyzer.invoke(annotation, "key");
    }

    private static <T> T invoke(Object obj, String methodName) {
        return (T)AnnotationAnalyzer.invoke(obj, methodName, null, null);
    }

    private static Object invoke(@NotNull Object obj, @NotEmpty String methodName, @Nullable Class<?>[] argTypes, @Nullable Object[] args) {
        Object[] argsIntern;
        Class<?>[] argTypesIntern;
        Contract.requireArgNotNull((String)"obj", (Object)obj);
        Contract.requireArgNotNull((String)"methodName", (Object)methodName);
        if (argTypes == null) {
            argTypesIntern = new Class[]{};
            if (args != null) {
                throw new IllegalArgumentException("The argument 'argTypes' is null but 'args' containes values!");
            }
            argsIntern = new Object[]{};
        } else {
            argTypesIntern = argTypes;
            if (args == null) {
                throw new IllegalArgumentException("The argument 'argTypes' contains classes but 'args' is null!");
            }
            argsIntern = args;
        }
        AnnotationAnalyzer.checkSameLength(argTypesIntern, argsIntern);
        Class returnType = UNKNOWN_CLASS.class;
        try {
            Method method = obj.getClass().getMethod(methodName, argTypesIntern);
            returnType = method.getReturnType() == null ? Void.TYPE : method.getReturnType();
            return method.invoke(obj, argsIntern);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Security problem with '" + AnnotationAnalyzer.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Method '" + AnnotationAnalyzer.getMethodSignature(returnType, methodName, argTypesIntern) + "' not found! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Argument problem with '" + AnnotationAnalyzer.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Access problem with '" + AnnotationAnalyzer.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Got an exception when calling '" + AnnotationAnalyzer.getMethodSignature(returnType, methodName, argTypesIntern) + "'! [" + obj.getClass().getName() + "]", ex);
        }
    }

    private static void checkSameLength(Class<?>[] argTypes, Object[] args) {
        if (argTypes.length != args.length) {
            throw new IllegalArgumentException("The argument 'argTypes' contains " + argTypes.length + " classes but 'args' only contains " + args.length + " arguments!");
        }
    }

    public static String getMethodSignature(@NotNull Class<?> returnType, @NotNull String methodName, Class<?>[] argTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(AnnotationAnalyzer.name(returnType));
        sb.append(" ");
        sb.append(methodName);
        sb.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(AnnotationAnalyzer.name(argTypes[i]));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static String name(@NotNull Class<?> clasz) {
        String name = CLASS_NAME_MAP.get(clasz);
        if (name == null) {
            return clasz.getName();
        }
        return name;
    }

    static {
        CLASS_NAME_MAP.put(Byte.class, Byte.class.getSimpleName());
        CLASS_NAME_MAP.put(Short.class, Short.class.getSimpleName());
        CLASS_NAME_MAP.put(Integer.class, Integer.class.getSimpleName());
        CLASS_NAME_MAP.put(Long.class, Long.class.getSimpleName());
        CLASS_NAME_MAP.put(Float.class, Float.class.getSimpleName());
        CLASS_NAME_MAP.put(String.class, String.class.getSimpleName());
        CLASS_NAME_MAP.put(Double.class, Double.class.getSimpleName());
        CLASS_NAME_MAP.put(Boolean.class, Boolean.class.getSimpleName());
    }

    private static final class UNKNOWN_CLASS {
        private UNKNOWN_CLASS() {
        }
    }
}

