/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.utils4j.filter.Filter;

public abstract class ListFilter
implements Filter {
    public static final String DEFAULT_OPEN_BRACKET = "(";
    public static final String DEFAULT_CLOSE_BRACKET = ")";
    private List filterList = new ArrayList();
    private String openBracket = "(";
    private String closeBracket = ")";

    public ListFilter() {
    }

    public ListFilter(Filter firstFilter, Filter secondFilter) {
        this.addFilter(firstFilter);
        this.addFilter(secondFilter);
    }

    public final void addFilter(Filter filter) {
        this.filterList.add(filter);
    }

    public final void removeFilter(Filter filter) {
        this.filterList.remove(filter);
    }

    protected final String toString(String opStr) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.openBracket);
        for (int i = 0; i < this.filterList.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
                sb.append(opStr);
                sb.append(" ");
            }
            Filter filter = (Filter)this.filterList.get(i);
            sb.append(filter.toString());
        }
        sb.append(this.closeBracket);
        return sb.toString();
    }

    public final String getCloseBracket() {
        if (this.closeBracket.equals(DEFAULT_CLOSE_BRACKET)) {
            return null;
        }
        return this.closeBracket;
    }

    public final String getOpenBracket() {
        if (this.openBracket.equals(DEFAULT_OPEN_BRACKET)) {
            return null;
        }
        return this.openBracket;
    }

    public final void setCloseBracket(String newCloseBracket) {
        this.closeBracket = newCloseBracket == null ? DEFAULT_CLOSE_BRACKET : newCloseBracket;
    }

    public final void setOpenBracket(String newOpenBracket) {
        this.openBracket = newOpenBracket == null ? DEFAULT_OPEN_BRACKET : newOpenBracket;
    }

    public final List getFilterList() {
        if (this.filterList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.filterList;
    }

    public final void setFilterList(List newList) {
        if (newList == null) {
            this.filterList.clear();
        } else {
            this.filterList = newList;
        }
    }
}

