/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.filter;

import java.util.StringTokenizer;
import org.fuin.utils4j.filter.Filter;

public class TokenFilter
implements Filter {
    private final String constValue;
    private final String separators;

    public TokenFilter(String constValue, String newSeparators) {
        this.constValue = constValue;
        this.separators = newSeparators;
    }

    public final String getSeparators() {
        return this.separators;
    }

    public final String getConstValue() {
        return this.constValue;
    }

    @Override
    public final boolean complies(Object value) {
        return this.complies((String)value, this.constValue, this.separators);
    }

    protected final boolean complies(String value, String constValue, String separators) {
        if (value == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(value, separators);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            if (!t.equals(constValue)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return " contains '" + this.constValue + "' [" + this.separators + "]";
    }
}

