/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.fuin.utils4j.Property;
import org.fuin.utils4j.Utils4J;

public final class MergeException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final Problem[] problems;

    public MergeException(File file, List<Problem> problems) {
        super("The properties file '" + file + "' was modified by someone else and cannot be merged! " + problems);
        Utils4J.checkNotNull("file", file);
        this.file = file;
        Utils4J.checkNotNull("problems", problems);
        this.problems = problems.toArray(new Problem[problems.size()]);
    }

    public MergeException(File file, Problem ... problems) {
        this(file, Arrays.asList(problems));
    }

    public final File getFile() {
        return this.file;
    }

    public final Problem[] getProblems() {
        return this.problems;
    }

    public static final class Problem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String text;
        private final Property prop;
        private final Property fileProp;

        public Problem(String text, Property prop, Property fileProp) {
            Utils4J.checkNotNull("text", text);
            this.text = text;
            Utils4J.checkNotNull("prop", prop);
            this.prop = prop;
            Utils4J.checkNotNull("fileProp", fileProp);
            this.fileProp = fileProp;
        }

        public final String getText() {
            return this.text;
        }

        public final Property getProp() {
            return this.prop;
        }

        public final Property getFileProp() {
            return this.fileProp;
        }

        public final String toString() {
            return this.text + " - Property: {" + this.prop + "}, File Property: {" + this.fileProp + "}";
        }
    }
}

