/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamWriter;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4j.jaxb.UnmarshallerBuilder;

public final class JaxbUtils {
    private static final String ERROR_MARSHALLING_TEST_DATA = "Error marshalling test data";
    public static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";

    private JaxbUtils() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of a utility class");
    }

    public static <T> String marshal(T data, Class<?> ... classesToBeBound) {
        return JaxbUtils.marshal(data, null, classesToBeBound);
    }

    public static <T> String marshal(T data, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        if (data == null) {
            return null;
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound);
            return JaxbUtils.marshal(ctx, data, adapters);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }

    public static <T> String marshal(JAXBContext ctx, T data) {
        return JaxbUtils.marshal(ctx, data, null);
    }

    public static <T> String marshal(JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters) {
        if (data == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        JaxbUtils.marshal(ctx, data, adapters, writer);
        return writer.toString();
    }

    public static <T> void marshal(JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters, Writer writer) {
        if (data == null) {
            return;
        }
        try {
            Marshaller marshaller = ctx.createMarshaller();
            if (adapters != null) {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    marshaller.setAdapter(adapter);
                }
            }
            marshaller.marshal(data, writer);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }

    public static <T> void marshal(JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters, XMLStreamWriter writer) {
        if (data == null) {
            return;
        }
        try {
            Marshaller marshaller = ctx.createMarshaller();
            if (adapters != null) {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    marshaller.setAdapter(adapter);
                }
            }
            marshaller.marshal(data, writer);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }

    public static <T> T unmarshal(String xmlData, Class<?> ... classesToBeBound) {
        UnmarshallerBuilder builder = new UnmarshallerBuilder();
        if (classesToBeBound != null) {
            builder.addClassesToBeBound(classesToBeBound);
        }
        builder.withHandler(event -> false);
        return JaxbUtils.unmarshal(builder.build(), xmlData);
    }

    public static <T> T unmarshal(String xmlData, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        UnmarshallerBuilder builder = new UnmarshallerBuilder();
        if (classesToBeBound != null) {
            builder.addClassesToBeBound(classesToBeBound);
        }
        builder.addAdapters(adapters);
        builder.withHandler(event -> false);
        return JaxbUtils.unmarshal(builder.build(), xmlData);
    }

    public static <T> T unmarshal(JAXBContext ctx, String xmlData, XmlAdapter<?, ?>[] adapters) {
        UnmarshallerBuilder builder = new UnmarshallerBuilder().withContext(ctx);
        if (adapters != null) {
            builder.addAdapters(adapters);
        }
        builder.withHandler(event -> false);
        return JaxbUtils.unmarshal(builder.build(), xmlData);
    }

    public static <T> T unmarshal(JAXBContext ctx, Reader reader, XmlAdapter<?, ?>[] adapters) {
        UnmarshallerBuilder builder = new UnmarshallerBuilder().withContext(ctx);
        if (adapters != null) {
            builder.addAdapters(adapters);
        }
        builder.withHandler(event -> false);
        return JaxbUtils.unmarshal(builder.build(), reader);
    }

    public static <T> T unmarshal(Unmarshaller unmarshaller, String xml) {
        Utils4J.checkNotNull("unmarshaller", unmarshaller);
        if (xml == null) {
            return null;
        }
        try {
            return (T)unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error unmarshalling from XML: " + xml, ex);
        }
    }

    public static <T> T unmarshal(Unmarshaller unmarshaller, Reader reader) {
        Utils4J.checkNotNull("unmarshaller", unmarshaller);
        Utils4J.checkNotNull("reader", reader);
        try {
            return (T)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error unmarshalling from reader", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(Unmarshaller unmarshaller, File file) {
        Utils4J.checkNotNull("unmarshaller", unmarshaller);
        Utils4J.checkNotNull("file", file);
        Utils4J.checkValidFile(file);
        try (FileReader reader = new FileReader(file);){
            Object object = unmarshaller.unmarshal((Reader)reader);
            return (T)object;
        }
        catch (JAXBException | IOException ex) {
            throw new RuntimeException("Error unmarshalling from file: " + file, ex);
        }
    }

    public static <T> String marshal(Marshaller marshaller, T data) {
        Utils4J.checkNotNull("marshaller", marshaller);
        if (data == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        JaxbUtils.marshal(marshaller, data, writer);
        return writer.toString();
    }

    public static <T> void marshal(Marshaller marshaller, T data, Writer writer) {
        Utils4J.checkNotNull("marshaller", marshaller);
        Utils4J.checkNotNull("writer", writer);
        if (data == null) {
            return;
        }
        try {
            marshaller.marshal(data, writer);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }

    public static <T> void marshal(Marshaller marshaller, T data, XMLStreamWriter writer) {
        Utils4J.checkNotNull("marshaller", marshaller);
        Utils4J.checkNotNull("writer", writer);
        if (data == null) {
            return;
        }
        try {
            marshaller.marshal(data, writer);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }
}

